/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus;

import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.TimeWindowMax;
import io.micrometer.core.instrument.util.MeterEquivalence;
import io.micrometer.core.lang.Nullable;
import java.time.Duration;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class PrometheusDistributionSummary
extends AbstractDistributionSummary {
    private LongAdder count = new LongAdder();
    private DoubleAdder amount = new DoubleAdder();
    private TimeWindowMax max;

    PrometheusDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        super(id, clock, DistributionStatisticConfig.builder().expiry(Duration.ofDays(1825L)).bufferLength(Integer.valueOf(1)).build().merge(distributionStatisticConfig), scale, true);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
    }

    protected void recordNonNegative(double amount) {
        this.count.increment();
        this.amount.add(amount);
        this.max.record(amount);
    }

    public long count() {
        return this.count.longValue();
    }

    public double totalAmount() {
        return this.amount.doubleValue();
    }

    public double max() {
        return this.max.poll();
    }

    public boolean equals(@Nullable Object o) {
        return MeterEquivalence.equals((Meter)this, (Object)o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode((Meter)this);
    }

    public CountAtBucket[] histogramCounts() {
        return this.histogram.takeSnapshot(0L, 0.0, 0.0).histogramCounts();
    }
}

