/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.TimeWindowMax;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.util.TimeUtils;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class PrometheusTimer
extends AbstractTimer {
    private final LongAdder count = new LongAdder();
    private final LongAdder totalTime = new LongAdder();
    private final TimeWindowMax max;

    PrometheusTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        super(id, clock, DistributionStatisticConfig.builder().expiry(Duration.ofDays(1825L)).bufferLength(Integer.valueOf(1)).build().merge(distributionStatisticConfig), pauseDetector, TimeUnit.SECONDS, true);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
    }

    protected void recordNonNegative(long amount, TimeUnit unit) {
        this.count.increment();
        long nanoAmount = TimeUnit.NANOSECONDS.convert(amount, unit);
        this.totalTime.add(nanoAmount);
        this.max.record((double)nanoAmount, TimeUnit.NANOSECONDS);
    }

    public long count() {
        return this.count.longValue();
    }

    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit((double)this.totalTime.doubleValue(), (TimeUnit)unit);
    }

    public double max(TimeUnit unit) {
        return this.max.poll(unit);
    }

    public CountAtBucket[] histogramCounts() {
        return this.histogram.takeSnapshot(0L, 0.0, 0.0).histogramCounts();
    }
}

