/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.signalfx;

import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.time.Duration;
import java.util.Arrays;

final class CumulativeHistogramConfigUtil {
    static DistributionStatisticConfig updateConfig(DistributionStatisticConfig distributionStatisticConfig) {
        double[] sloBoundaries = distributionStatisticConfig.getServiceLevelObjectiveBoundaries();
        if (sloBoundaries == null || sloBoundaries.length == 0) {
            return distributionStatisticConfig;
        }
        double[] newSloBoundaries = sloBoundaries;
        if (!CumulativeHistogramConfigUtil.isPositiveInf(sloBoundaries[sloBoundaries.length - 1])) {
            newSloBoundaries = Arrays.copyOf(sloBoundaries, sloBoundaries.length + 1);
            newSloBoundaries[newSloBoundaries.length - 1] = Double.MAX_VALUE;
        }
        return DistributionStatisticConfig.builder().expiry(Duration.ofNanos(Long.MAX_VALUE)).bufferLength(Integer.valueOf(1)).serviceLevelObjectives(newSloBoundaries).build().merge(distributionStatisticConfig);
    }

    private static boolean isPositiveInf(double bucket) {
        return bucket == Double.POSITIVE_INFINITY || bucket == Double.MAX_VALUE || (long)bucket == Long.MAX_VALUE;
    }

    private CumulativeHistogramConfigUtil() {
    }
}

