/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.signalfx;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.TimeWindowMax;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.step.StepTuple2;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.signalfx.CumulativeHistogramConfigUtil;
import io.micrometer.signalfx.DeltaHistogramCounts;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

final class SignalfxTimer
extends AbstractTimer {
    private final LongAdder count = new LongAdder();
    private final LongAdder total = new LongAdder();
    private final StepTuple2<Long, Long> countTotal;
    private final TimeWindowMax max;
    @Nullable
    private final DeltaHistogramCounts deltaHistogramCounts;

    SignalfxTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit baseTimeUnit, long stepMillis, boolean isDelta) {
        super(id, clock, CumulativeHistogramConfigUtil.updateConfig(distributionStatisticConfig), pauseDetector, baseTimeUnit, false);
        this.countTotal = new StepTuple2(clock, stepMillis, (Object)0L, (Object)0L, this.count::sumThenReset, this.total::sumThenReset);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
        this.deltaHistogramCounts = distributionStatisticConfig.isPublishingHistogram() && isDelta ? new DeltaHistogramCounts() : null;
    }

    protected void recordNonNegative(long amount, TimeUnit unit) {
        long nanoAmount = (long)TimeUtils.convert((double)amount, (TimeUnit)unit, (TimeUnit)TimeUnit.NANOSECONDS);
        this.count.increment();
        this.total.add(nanoAmount);
        this.max.record((double)amount, unit);
    }

    public long count() {
        return (Long)this.countTotal.poll1();
    }

    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit((double)((Long)this.countTotal.poll2()).longValue(), (TimeUnit)unit);
    }

    public double max(TimeUnit unit) {
        return this.max.poll(unit);
    }

    public HistogramSnapshot takeSnapshot() {
        HistogramSnapshot currentSnapshot = super.takeSnapshot();
        if (this.deltaHistogramCounts == null) {
            return currentSnapshot;
        }
        return new HistogramSnapshot(currentSnapshot.count(), currentSnapshot.total(), currentSnapshot.max(), currentSnapshot.percentileValues(), this.deltaHistogramCounts.calculate(currentSnapshot.histogramCounts()), (arg_0, arg_1) -> ((HistogramSnapshot)currentSnapshot).outputSummary(arg_0, arg_1));
    }
}

