/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.util.MeterEquivalence;
import io.micrometer.statsd.StatsdLineBuilder;
import java.util.concurrent.atomic.DoubleAdder;
import org.reactivestreams.Subscriber;

public class StatsdCounter
extends AbstractMeter
implements Counter {
    private DoubleAdder count = new DoubleAdder();
    private final StatsdLineBuilder lineBuilder;
    private final Subscriber<String> publisher;

    StatsdCounter(Meter.Id id, StatsdLineBuilder lineBuilder, Subscriber<String> publisher) {
        super(id);
        this.lineBuilder = lineBuilder;
        this.publisher = publisher;
    }

    public void increment(double amount) {
        if (amount > 0.0) {
            this.count.add(amount);
            this.publisher.onNext((Object)this.lineBuilder.count((long)amount));
        }
    }

    public double count() {
        return this.count.doubleValue();
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals((Meter)this, (Object)o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode((Meter)this);
    }
}

