/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.statsd.StatsdFlavor;
import io.micrometer.statsd.internal.MemoizingSupplier;
import java.beans.Introspector;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class StatsdLineBuilder {
    private final Meter.Id id;
    private final StatsdFlavor flavor;
    private final HierarchicalNameMapper nameMapper;
    private final MeterRegistry.Config config;
    private final Function<NamingConvention, String> datadogTagString;
    private final Function<NamingConvention, String> telegrafTagString;
    private static final ThreadLocal<NumberFormat> NUMBER_FORMATTERS = ThreadLocal.withInitial(() -> {
        NumberFormat numberFormatter = NumberFormat.getInstance(Locale.US);
        numberFormatter.setGroupingUsed(false);
        numberFormatter.setMaximumFractionDigits(6);
        DecimalFormat decimalFormat = (DecimalFormat)numberFormatter;
        DecimalFormatSymbols symbols = decimalFormat.getDecimalFormatSymbols();
        symbols.setNaN("NaN");
        decimalFormat.setDecimalFormatSymbols(symbols);
        return numberFormatter;
    });

    StatsdLineBuilder(Meter.Id id, StatsdFlavor flavor, HierarchicalNameMapper nameMapper, MeterRegistry.Config config) {
        this.id = id;
        this.flavor = flavor;
        this.nameMapper = nameMapper;
        this.config = config;
        this.datadogTagString = MemoizingSupplier.memoize(convention -> id.getTags().iterator().hasNext() ? id.getConventionTags(convention).stream().map(t -> t.getKey() + ":" + t.getValue()).collect(Collectors.joining(",")) : null);
        this.telegrafTagString = MemoizingSupplier.memoize(convention -> id.getTags().iterator().hasNext() ? id.getConventionTags(convention).stream().map(t -> t.getKey() + "=" + t.getValue()).collect(Collectors.joining(",")) : null);
    }

    String count(long amount) {
        return this.count(amount, Statistic.Count);
    }

    String count(long amount, Statistic stat) {
        return this.line(Long.toString(amount), stat, "c");
    }

    String gauge(double amount) {
        return this.gauge(amount, Statistic.Value);
    }

    String gauge(double amount, Statistic stat) {
        return this.line(NUMBER_FORMATTERS.get().format(amount), stat, "g");
    }

    String histogram(double amount) {
        return this.line(NUMBER_FORMATTERS.get().format(amount), null, "h");
    }

    String timing(double timeMs) {
        return this.line(NUMBER_FORMATTERS.get().format(timeMs), null, "ms");
    }

    private String line(String amount, Statistic stat, String type) {
        switch (this.flavor) {
            case Etsy: {
                return this.metricName(stat) + ":" + amount + "|" + type;
            }
            case Datadog: {
                return this.metricName(stat) + ":" + amount + "|" + type + this.tags(stat, this.datadogTagString.apply(this.config.namingConvention()), ":", "|#");
            }
        }
        return this.metricName(stat) + this.tags(stat, this.telegrafTagString.apply(this.config.namingConvention()), "=", ",") + ":" + amount + "|" + type;
    }

    private String tags(Statistic stat, String otherTags, String keyValueSeparator, String preamble) {
        String tags = Stream.of(stat == null ? null : "statistic" + keyValueSeparator + Introspector.decapitalize(stat.toString()), otherTags).filter(Objects::nonNull).collect(Collectors.joining(","));
        if (!tags.isEmpty()) {
            tags = preamble + tags;
        }
        return tags;
    }

    private String metricName(Statistic stat) {
        switch (this.flavor) {
            case Etsy: {
                return this.nameMapper.toHierarchicalName(this.id.withTag(stat), this.config.namingConvention());
            }
        }
        return this.config.namingConvention().name(this.id.getName(), this.id.getType(), this.id.getBaseUnit());
    }
}

