/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.statsd.StatsdConfig;
import io.micrometer.statsd.StatsdCounter;
import io.micrometer.statsd.StatsdDistributionSummary;
import io.micrometer.statsd.StatsdGauge;
import io.micrometer.statsd.StatsdLineBuilder;
import io.micrometer.statsd.StatsdLongTaskTimer;
import io.micrometer.statsd.StatsdPollable;
import io.micrometer.statsd.StatsdTimer;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.UnicastProcessor;
import reactor.ipc.netty.NettyPipeline;
import reactor.ipc.netty.udp.UdpClient;
import reactor.util.concurrent.Queues;

public class StatsdMeterRegistry
extends MeterRegistry {
    private final StatsdConfig statsdConfig;
    private final HierarchicalNameMapper nameMapper;
    private volatile UnicastProcessor<String> publisher;
    private Disposable.Swap udpClient = Disposables.swap();
    private final Collection<StatsdPollable> pollableMeters = Collections.synchronizedCollection(new LinkedList());
    Disposable.Swap meterPoller = Disposables.swap();
    private final DecimalFormat percentileFormat = new DecimalFormat("#.####");

    public StatsdMeterRegistry(StatsdConfig config, Clock clock) {
        this(config, null, clock);
    }

    public StatsdMeterRegistry(StatsdConfig config, HierarchicalNameMapper nameMapper, Clock clock) {
        super(clock);
        this.statsdConfig = config;
        this.nameMapper = Optional.ofNullable(nameMapper).orElse(HierarchicalNameMapper.DEFAULT);
        switch (this.statsdConfig.flavor()) {
            case Datadog: {
                this.config().namingConvention(NamingConvention.dot);
                break;
            }
            case Telegraf: {
                this.config().namingConvention(NamingConvention.snakeCase);
                break;
            }
            default: {
                this.config().namingConvention(NamingConvention.camelCase);
            }
        }
        this.publisher = UnicastProcessor.create((Queue)((Queue)Queues.get((int)this.statsdConfig.queueSize()).get()));
        this.gauge("statsd.queue.size", this.publisher, UnicastProcessor::size);
        this.gauge("statsd.queue.capacity", this.publisher, UnicastProcessor::getBufferSize);
        if (config.enabled()) {
            this.start();
        }
    }

    public void start() {
        UdpClient.create((String)this.statsdConfig.host(), (int)this.statsdConfig.port()).newHandler((in, out) -> out.options(NettyPipeline.SendOptions::flushOnEach).sendString(this.publisher).neverComplete()).subscribe(client -> {
            this.udpClient.replace((Disposable)client);
            this.meterPoller.replace(Flux.interval((Duration)this.statsdConfig.pollingFrequency()).doOnEach(n -> {
                Collection<StatsdPollable> collection = this.pollableMeters;
                synchronized (collection) {
                    this.pollableMeters.forEach(StatsdPollable::poll);
                }
            }).subscribe());
        });
    }

    public void stop() {
        this.udpClient.dispose();
        this.meterPoller.dispose();
    }

    protected <T> Gauge newGauge(Meter.Id id, T obj, ToDoubleFunction<T> f) {
        StatsdGauge<T> gauge = new StatsdGauge<T>(id, this.lineBuilder(id), (Subscriber<String>)this.publisher, obj, f);
        this.pollableMeters.add(gauge);
        return gauge;
    }

    protected Counter newCounter(Meter.Id id) {
        return new StatsdCounter(id, this.lineBuilder(id), (Subscriber<String>)this.publisher);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        StatsdLongTaskTimer ltt = new StatsdLongTaskTimer(id, this.lineBuilder(id), (Subscriber<String>)this.publisher, this.clock);
        this.pollableMeters.add(ltt);
        return ltt;
    }

    protected Timer newTimer(Meter.Id id, HistogramConfig histogramConfig) {
        StatsdTimer timer = new StatsdTimer(id, this.lineBuilder(id), (Processor<String, String>)this.publisher, this.clock, histogramConfig, this.statsdConfig.step().toMillis());
        block5: for (double percentile : histogramConfig.getPercentiles()) {
            switch (this.statsdConfig.flavor()) {
                case Datadog: {
                    this.gauge(id.getName() + "." + this.percentileFormat.format(percentile * 100.0) + "percentile", (Object)timer, t -> t.percentile(percentile, this.getBaseTimeUnit()));
                    continue block5;
                }
                case Telegraf: {
                    this.gauge(id.getName() + "." + this.percentileFormat.format(percentile * 100.0) + ".percentile", (Object)timer, t -> t.percentile(percentile, this.getBaseTimeUnit()));
                    continue block5;
                }
                case Etsy: {
                    this.gauge(id.getName(), Tags.concat((Iterable)this.getConventionTags(id), (String[])new String[]{"percentile", this.percentileFormat.format(percentile * 100.0)}), (Object)timer, t -> t.percentile(percentile, this.getBaseTimeUnit()));
                }
            }
        }
        if (histogramConfig.isPublishingHistogram()) {
            Object object = histogramConfig.getHistogramBuckets(false).iterator();
            while (object.hasNext()) {
                Long bucket = (Long)object.next();
                this.more().counter(id.getName() + ".histogram", Tags.concat((Iterable)this.getConventionTags(id), (String[])new String[]{"bucket", this.percentileFormat.format(TimeUtils.nanosToUnit((double)bucket.longValue(), (TimeUnit)TimeUnit.MILLISECONDS))}), (Object)timer, s -> s.histogramCountAtValue(bucket.longValue()));
            }
        }
        return timer;
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, HistogramConfig histogramConfig) {
        StatsdDistributionSummary summary = new StatsdDistributionSummary(id, this.lineBuilder(id), (Subscriber<String>)this.publisher, this.clock, histogramConfig, this.statsdConfig.step().toMillis());
        block5: for (double percentile : histogramConfig.getPercentiles()) {
            switch (this.statsdConfig.flavor()) {
                case Datadog: {
                    this.gauge(id.getName() + "." + this.percentileFormat.format(percentile * 100.0) + "percentile", (Object)summary, s -> s.percentile(percentile));
                    continue block5;
                }
                case Telegraf: {
                    this.gauge(id.getName() + "." + this.percentileFormat.format(percentile * 100.0) + ".percentile", (Object)summary, s -> s.percentile(percentile));
                    continue block5;
                }
                case Etsy: {
                    this.gauge(id.getName(), Tags.concat((Iterable)this.getConventionTags(id), (String[])new String[]{"percentile", this.percentileFormat.format(percentile * 100.0)}), (Object)summary, s -> s.percentile(percentile));
                }
            }
        }
        if (histogramConfig.isPublishingHistogram()) {
            Object object = histogramConfig.getHistogramBuckets(false).iterator();
            while (object.hasNext()) {
                Long bucket = (Long)object.next();
                this.more().counter(id.getName() + ".histogram", Tags.concat((Iterable)this.getConventionTags(id), (String[])new String[]{"bucket", Long.toString(bucket)}), (Object)summary, s -> s.histogramCountAtValue(bucket.longValue()));
            }
        }
        return summary;
    }

    protected void newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        measurements.forEach(ms -> {
            StatsdLineBuilder line = this.lineBuilder(id);
            switch (ms.getStatistic()) {
                case Count: 
                case Total: 
                case TotalTime: {
                    this.pollableMeters.add(() -> this.publisher.onNext((Object)line.count((long)ms.getValue(), ms.getStatistic())));
                    break;
                }
                case Value: 
                case ActiveTasks: 
                case Duration: 
                case Unknown: {
                    this.pollableMeters.add(() -> this.publisher.onNext((Object)line.gauge(ms.getValue(), ms.getStatistic())));
                }
            }
        });
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    private StatsdLineBuilder lineBuilder(Meter.Id id) {
        return new StatsdLineBuilder(id, this.statsdConfig.flavor(), this.nameMapper, this.config());
    }
}

