/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.histogram.HistogramConfig;
import io.micrometer.core.instrument.step.StepDouble;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.statsd.StatsdLineBuilder;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import org.reactivestreams.Processor;

public class StatsdTimer
extends AbstractTimer
implements Timer {
    private final LongAdder count = new LongAdder();
    private final DoubleAdder totalTime = new DoubleAdder();
    private StepDouble max;
    private final StatsdLineBuilder lineBuilder;
    private final Processor<String, String> publisher;

    StatsdTimer(Meter.Id id, StatsdLineBuilder lineBuilder, Processor<String, String> publisher, Clock clock, HistogramConfig histogramConfig, long stepMillis) {
        super(id, clock, histogramConfig);
        this.max = new StepDouble(clock, stepMillis);
        this.lineBuilder = lineBuilder;
        this.publisher = publisher;
    }

    protected void recordNonNegative(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            this.count.increment();
            double msAmount = TimeUtils.convert((double)amount, (TimeUnit)unit, (TimeUnit)TimeUnit.MILLISECONDS);
            this.totalTime.add(msAmount);
            this.max.getCurrent().add(Math.max(msAmount - this.max.getCurrent().doubleValue(), 0.0));
            this.publisher.onNext((Object)this.lineBuilder.timing(msAmount));
        }
    }

    public long count() {
        return this.count.longValue();
    }

    public double totalTime(TimeUnit unit) {
        return TimeUtils.convert((double)this.totalTime.doubleValue(), (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)unit);
    }

    public double max(TimeUnit unit) {
        return TimeUtils.convert((double)this.max.poll(), (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)unit);
    }
}

