/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty;

import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.ipc.netty.NettyContext;
import io.micrometer.shaded.reactor.ipc.netty.NettyInbound;
import io.micrometer.shaded.reactor.ipc.netty.NettyOutbound;
import io.micrometer.shaded.reactor.ipc.netty.tcp.BlockingNettyContext;
import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public interface NettyConnector<INBOUND extends NettyInbound, OUTBOUND extends NettyOutbound> {
    public Mono<? extends NettyContext> newHandler(BiFunction<? super INBOUND, ? super OUTBOUND, ? extends Publisher<Void>> var1);

    default public <T extends BiFunction<INBOUND, OUTBOUND, ? extends Publisher<Void>>> BlockingNettyContext start(T handler) {
        return new BlockingNettyContext(this.newHandler(handler), this.getClass().getSimpleName());
    }

    default public <T extends BiFunction<INBOUND, OUTBOUND, ? extends Publisher<Void>>> BlockingNettyContext start(T handler, Duration timeout) {
        return new BlockingNettyContext(this.newHandler(handler), this.getClass().getSimpleName(), timeout);
    }

    default public <T extends BiFunction<INBOUND, OUTBOUND, ? extends Publisher<Void>>> void startAndAwait(T handler) {
        this.startAndAwait(handler, null);
    }

    default public <T extends BiFunction<INBOUND, OUTBOUND, ? extends Publisher<Void>>> void startAndAwait(T handler, @Nullable Consumer<BlockingNettyContext> onStart) {
        BlockingNettyContext facade = new BlockingNettyContext(this.newHandler(handler), this.getClass().getSimpleName());
        facade.installShutdownHook();
        if (onStart != null) {
            onStart.accept(facade);
        }
        facade.getContext().onClose().block();
    }
}

