/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.http.server;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.channel.ChannelDuplexHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelPipeline;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpMessage;
import io.micrometer.shaded.reactor.ipc.netty.NettyPipeline;
import io.micrometer.shaded.reactor.ipc.netty.http.server.FilteringHttpContentCompressor;
import java.util.ArrayDeque;
import java.util.Queue;

final class CompressionHandler
extends ChannelDuplexHandler {
    final int minResponseSize;
    final Queue<Object> messages = new ArrayDeque<Object>();
    int bodyCompressThreshold;

    CompressionHandler(int minResponseSize) {
        this.minResponseSize = minResponseSize;
        this.bodyCompressThreshold = minResponseSize;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            this.offerByteBuf(ctx, msg, promise);
        } else if (msg instanceof HttpMessage) {
            this.offerHttpMessage(msg, promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (!(evt != NettyPipeline.responseCompressionEvent() || this.bodyCompressThreshold <= 0 && this.messages.isEmpty())) {
            while (!this.messages.isEmpty()) {
                Object msg = this.messages.poll();
                ChannelPromise p = (ChannelPromise)this.messages.poll();
                this.writeSkipCompress(ctx, msg, p);
            }
        }
        super.userEventTriggered(ctx, evt);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.releaseMsgs();
        super.exceptionCaught(ctx, cause);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.releaseMsgs();
        super.close(ctx, promise);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.addCompressionHandlerOnce(ctx, ctx.pipeline());
    }

    void offerHttpMessage(Object msg, ChannelPromise p) {
        this.messages.offer(msg);
        this.messages.offer(p);
        p.setSuccess();
    }

    void offerByteBuf(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ByteBuf byteBuf = (ByteBuf)msg;
        this.messages.offer(byteBuf);
        this.messages.offer(promise);
        if (this.bodyCompressThreshold > 0) {
            this.bodyCompressThreshold -= byteBuf.readableBytes();
        }
        this.drain(ctx);
    }

    void drain(ChannelHandlerContext ctx) throws Exception {
        if (this.bodyCompressThreshold <= 0) {
            while (!this.messages.isEmpty()) {
                Object message = this.messages.poll();
                ChannelPromise p = (ChannelPromise)this.messages.poll();
                this.writeCompress(ctx, message, p);
            }
        }
    }

    void writeCompress(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpMessage) {
            ctx.write(msg);
        } else {
            ctx.write(msg, promise);
        }
    }

    void writeSkipCompress(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpMessage) {
            ctx.write(FilteringHttpContentCompressor.FilterMessage.wrap(msg));
        } else {
            ctx.write(FilteringHttpContentCompressor.FilterMessage.wrap(msg), promise);
        }
    }

    void releaseMsgs() {
        while (!this.messages.isEmpty()) {
            Object msg = this.messages.poll();
            if (!(msg instanceof ByteBuf)) continue;
            ((ByteBuf)msg).release();
        }
    }

    void addCompressionHandlerOnce(ChannelHandlerContext ctx, ChannelPipeline cp) {
        if (cp.get(FilteringHttpContentCompressor.class) == null) {
            ctx.pipeline().addBefore("io.micrometer.shaded.reactor.left.compressionHandler", "io.micrometer.shaded.reactor.left.compressor", new FilteringHttpContentCompressor());
        }
    }
}

