/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.ByteBufAllocator;
import io.micrometer.shaded.io.netty.buffer.Unpooled;
import io.micrometer.shaded.io.netty.channel.DefaultFileRegion;
import io.micrometer.shaded.io.netty.handler.ssl.SslHandler;
import io.micrometer.shaded.io.netty.handler.stream.ChunkedInput;
import io.micrometer.shaded.io.netty.handler.stream.ChunkedNioFile;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.org.reactorstreams.Subscriber;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.ipc.netty.FutureMono;
import io.micrometer.shaded.reactor.ipc.netty.NettyContext;
import io.micrometer.shaded.reactor.ipc.netty.NettyPipeline;
import io.micrometer.shaded.reactor.ipc.netty.PublisherContext;
import io.micrometer.shaded.reactor.ipc.netty.ReactorNetty;
import io.micrometer.shaded.reactor.ipc.netty.channel.data.AbstractFileChunkedStrategy;
import io.micrometer.shaded.reactor.ipc.netty.channel.data.FileChunkedStrategy;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.function.Consumer;

public interface NettyOutbound
extends Publisher<Void> {
    public static final FileChunkedStrategy<ByteBuf> FILE_CHUNKED_STRATEGY_BUFFER = new AbstractFileChunkedStrategy<ByteBuf>(){

        @Override
        public ChunkedInput<ByteBuf> chunkFile(FileChannel fileChannel) {
            try {
                return new ChunkedNioFile(fileChannel, 1024);
            }
            catch (IOException e) {
                throw Exceptions.propagate(e);
            }
        }
    };

    default public ByteBufAllocator alloc() {
        return this.context().channel().alloc();
    }

    public NettyContext context();

    default public NettyOutbound context(Consumer<NettyContext> contextCallback) {
        contextCallback.accept(this.context());
        return this;
    }

    default public FileChunkedStrategy getFileChunkedStrategy() {
        return FILE_CHUNKED_STRATEGY_BUFFER;
    }

    default public Mono<Void> neverComplete() {
        return this.then(Mono.never()).then();
    }

    default public NettyOutbound onWriteIdle(long idleTimeout, Runnable onWriteIdle) {
        this.context().removeHandler("io.micrometer.shaded.reactor.left.onChannelWriteIdle");
        this.context().addHandlerFirst("io.micrometer.shaded.reactor.left.onChannelWriteIdle", new ReactorNetty.OutboundIdleStateHandler(idleTimeout, onWriteIdle));
        return this;
    }

    default public NettyOutbound options(Consumer<? super NettyPipeline.SendOptions> configurator) {
        this.context().channel().pipeline().fireUserEventTriggered(new NettyPipeline.SendOptionsChangeEvent(configurator, null));
        return this;
    }

    default public NettyOutbound send(Publisher<? extends ByteBuf> dataStream) {
        return this.sendObject(dataStream);
    }

    default public NettyOutbound sendByteArray(Publisher<? extends byte[]> dataStream) {
        return this.send(PublisherContext.publisherOrScalarMap(dataStream, Unpooled::wrappedBuffer));
    }

    default public NettyOutbound sendFile(Path file) {
        try {
            return this.sendFile(file, 0L, Files.size(file));
        }
        catch (IOException e) {
            return this.then(Mono.error(e));
        }
    }

    default public NettyOutbound sendFile(Path file, long position, long count) {
        Objects.requireNonNull(file);
        if (this.context().channel().pipeline().get(SslHandler.class) != null) {
            return this.sendFileChunked(file, position, count);
        }
        return this.then(Mono.using(() -> FileChannel.open(file, StandardOpenOption.READ), fc -> FutureMono.from(this.context().channel().writeAndFlush(new DefaultFileRegion((FileChannel)fc, position, count))), fc -> {
            try {
                fc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }));
    }

    default public NettyOutbound sendFileChunked(Path file, long position, long count) {
        boolean needChunkedWriteHandler;
        Objects.requireNonNull(file);
        FileChunkedStrategy strategy = this.getFileChunkedStrategy();
        boolean bl = needChunkedWriteHandler = this.context().channel().pipeline().get("io.micrometer.shaded.reactor.left.chunkedWriter") == null;
        if (needChunkedWriteHandler) {
            strategy.preparePipeline(this.context());
        }
        return this.then(Mono.using(() -> FileChannel.open(file, StandardOpenOption.READ), fc -> {
            try {
                ChunkedInput message = strategy.chunkFile((FileChannel)fc);
                return FutureMono.from(this.context().channel().writeAndFlush(message));
            }
            catch (Exception e) {
                return Mono.error(e);
            }
        }, fc -> {
            try {
                fc.close();
            }
            catch (IOException iOException) {
            }
            finally {
                strategy.cleanupPipeline(this.context());
            }
        }));
    }

    default public NettyOutbound sendGroups(Publisher<? extends Publisher<? extends ByteBuf>> dataStreams) {
        return this.then(Flux.from(dataStreams).concatMapDelayError(this::send, false, 32).then());
    }

    default public NettyOutbound sendObject(Publisher<?> dataStream) {
        return this.then(FutureMono.deferFutureWithContext(subscriberContext -> this.context().channel().writeAndFlush(PublisherContext.withContext(dataStream, subscriberContext))));
    }

    default public NettyOutbound sendObject(Object msg) {
        return this.then(FutureMono.deferFuture(() -> this.context().channel().writeAndFlush(msg)));
    }

    default public NettyOutbound sendString(Publisher<? extends String> dataStream) {
        return this.sendString(dataStream, Charset.defaultCharset());
    }

    default public NettyOutbound sendString(Publisher<? extends String> dataStream, Charset charset) {
        return this.sendObject(PublisherContext.publisherOrScalarMap(dataStream, s -> this.alloc().buffer().writeBytes(s.getBytes(charset))));
    }

    @Override
    default public void subscribe(Subscriber<? super Void> s) {
        this.then().subscribe(s);
    }

    default public Mono<Void> then() {
        return Mono.empty();
    }

    default public NettyOutbound then(Publisher<Void> other) {
        return new ReactorNetty.OutboundThen(this, other);
    }
}

