/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty;

import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.util.context.Context;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Function;

abstract class PublisherContext {
    PublisherContext() {
    }

    static <T> Publisher<T> withContext(Publisher<T> publisher, Context context) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(context);
        if (publisher instanceof Callable) {
            return publisher;
        }
        if (publisher instanceof Flux) {
            return ((Flux)publisher).subscriberContext(context);
        }
        if (publisher instanceof Mono) {
            return ((Mono)publisher).subscriberContext(context);
        }
        return publisher;
    }

    static <T, V> Publisher<V> publisherOrScalarMap(Publisher<T> publisher, Function<? super T, ? extends V> mapper) {
        if (publisher instanceof Callable) {
            return Mono.fromCallable(new ScalarMap<T, V>(publisher, mapper));
        }
        return Flux.from(publisher).map(mapper);
    }

    static final class ScalarMap<T, V>
    implements Callable<V> {
        final Callable<T> source;
        final Function<? super T, ? extends V> mapper;

        public ScalarMap(Publisher<T> source, Function<? super T, ? extends V> mapper) {
            this.source = (Callable)((Object)source);
            this.mapper = mapper;
        }

        @Override
        public V call() throws Exception {
            T called = this.source.call();
            if (called == null) {
                return null;
            }
            return this.mapper.apply(called);
        }
    }
}

