/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.channel;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.ByteBufHolder;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.EventLoop;
import io.micrometer.shaded.io.netty.util.ReferenceCountUtil;
import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.ipc.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import io.micrometer.shaded.reactor.util.concurrent.Queues;
import io.micrometer.shaded.reactor.util.context.Context;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class FluxReceive
extends Flux<Object>
implements Subscription,
Disposable {
    final Channel channel;
    final ChannelOperations<?, ?> parent;
    final EventLoop eventLoop;
    CoreSubscriber<? super Object> receiver;
    boolean receiverFastpath;
    long receiverDemand;
    Queue<Object> receiverQueue;
    volatile boolean inboundDone;
    Throwable inboundError;
    volatile Disposable receiverCancel;
    volatile int wip;
    static final AtomicIntegerFieldUpdater<FluxReceive> WIP = AtomicIntegerFieldUpdater.newUpdater(FluxReceive.class, "wip");
    static final AtomicReferenceFieldUpdater<FluxReceive, Disposable> CANCEL = AtomicReferenceFieldUpdater.newUpdater(FluxReceive.class, Disposable.class, "receiverCancel");
    static final Disposable CANCELLED = () -> {};
    static final Logger log = Loggers.getLogger(FluxReceive.class);

    FluxReceive(ChannelOperations<?, ?> parent) {
        this.parent = parent;
        this.channel = parent.channel;
        this.eventLoop = this.channel.eventLoop();
        CANCEL.lazySet(this, () -> {
            if (this.eventLoop.inEventLoop()) {
                this.unsubscribeReceiver();
            } else {
                this.eventLoop.execute(this::unsubscribeReceiver);
            }
        });
    }

    @Override
    public void cancel() {
        this.cancelReceiver();
        this.drainReceiver();
    }

    final long getPending() {
        return this.receiverQueue != null ? (long)this.receiverQueue.size() : 0L;
    }

    final boolean isCancelled() {
        return this.receiverCancel == CANCELLED;
    }

    final void discard() {
        this.inboundDone = true;
        this.receiverCancel = CANCELLED;
        this.drainReceiver();
    }

    @Override
    public void dispose() {
        this.cancel();
    }

    @Override
    public boolean isDisposed() {
        return this.inboundDone && (this.receiverQueue == null || this.receiverQueue.isEmpty());
    }

    @Override
    public void request(long n) {
        if (Operators.validate(n)) {
            if (this.eventLoop.inEventLoop()) {
                this.receiverDemand = Operators.addCap(this.receiverDemand, n);
                this.drainReceiver();
            } else {
                this.eventLoop.execute(() -> {
                    this.receiverDemand = Operators.addCap(this.receiverDemand, n);
                    this.drainReceiver();
                });
            }
        }
    }

    @Override
    public void subscribe(CoreSubscriber<? super Object> s) {
        if (this.eventLoop.inEventLoop()) {
            this.startReceiver(s);
        } else {
            this.eventLoop.execute(() -> this.startReceiver(s));
        }
    }

    final boolean cancelReceiver() {
        Disposable c = this.receiverCancel;
        if (c != CANCELLED && (c = CANCEL.getAndSet(this, CANCELLED)) != CANCELLED) {
            c.dispose();
            return true;
        }
        return false;
    }

    final void cleanQueue(Queue<Object> q) {
        if (q != null) {
            Object o;
            while ((o = q.poll()) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Dropping frame {}, {} in buffer", o, this.getPending());
                }
                ReferenceCountUtil.release(o);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    final void drainReceiver() {
        if (FluxReceive.WIP.getAndIncrement(this) != 0) {
            return;
        }
        missed = 1;
        do lbl-1000:
        // 3 sources

        {
            block16: {
                q = this.receiverQueue;
                a = this.receiver;
                d = this.inboundDone;
                if (a != null) break block16;
                if (this.isCancelled()) {
                    this.cleanQueue(q);
                    return;
                }
                if (d && this.getPending() == 0L) {
                    ex = this.inboundError;
                    if (ex != null) {
                        this.parent.context.fireContextError(ex);
                    } else {
                        this.parent.context.fireContextActive(this.parent);
                    }
                    return;
                }
                if ((missed = FluxReceive.WIP.addAndGet(this, -missed)) != 0) ** GOTO lbl-1000
                break;
            }
            r = this.receiverDemand;
            for (e = 0L; e != r; ++e) {
                if (this.isCancelled()) {
                    this.cleanQueue(q);
                    this.terminateReceiver(q, a);
                    return;
                }
                d = this.inboundDone;
                v = q != null ? q.poll() : null;
                v0 = empty = v == null;
                if (d && empty) {
                    this.terminateReceiver(q, a);
                    return;
                }
                if (empty) break;
                try {
                    a.onNext(v);
                    continue;
                }
                finally {
                    ReferenceCountUtil.release(v);
                }
            }
            if (this.isCancelled()) {
                this.cleanQueue(q);
                this.terminateReceiver(q, a);
                return;
            }
            if (this.inboundDone && (q == null || q.isEmpty())) {
                this.terminateReceiver(q, a);
                return;
            }
            if (r == 0x7FFFFFFFFFFFFFFFL) {
                this.channel.config().setAutoRead(true);
                this.channel.read();
                missed = FluxReceive.WIP.addAndGet(this, -missed);
                if (missed == 0) break;
                this.receiverFastpath = true;
            }
            if ((this.receiverDemand -= e) <= 0L && e <= 0L) continue;
            this.channel.read();
        } while ((missed = FluxReceive.WIP.addAndGet(this, -missed)) != 0);
    }

    final void startReceiver(CoreSubscriber<? super Object> s) {
        if (this.receiver == null) {
            if (log.isDebugEnabled()) {
                log.debug("{} Subscribing inbound receiver [pending: {}, cancelled:{}, inboundDone: {}]", this.channel.toString(), this.getPending(), this.isCancelled(), this.inboundDone);
            }
            if (this.inboundDone && this.getPending() == 0L) {
                if (this.inboundError != null) {
                    Operators.error(s, this.inboundError);
                    return;
                }
                Operators.complete(s);
                return;
            }
            this.receiver = s;
            s.onSubscribe(this);
        } else {
            Operators.error(s, new IllegalStateException("Only one connection receive subscriber allowed."));
        }
    }

    final void onInboundNext(Object msg) {
        if (this.inboundDone || this.isCancelled()) {
            if (log.isDebugEnabled()) {
                log.debug("Dropping frame {}, {} in buffer", msg, this.getPending());
            }
            ReferenceCountUtil.release(msg);
            return;
        }
        if (this.receiverFastpath && this.receiver != null) {
            try {
                if (log.isDebugEnabled()) {
                    if (msg instanceof ByteBuf) {
                        ((ByteBuf)msg).touch("Unbounded receiver, bypass inbound buffer queue");
                    } else if (msg instanceof ByteBufHolder) {
                        ((ByteBufHolder)msg).touch("Unbounded receiver, bypass inbound buffer queue");
                    }
                }
                this.receiver.onNext(msg);
            }
            finally {
                ReferenceCountUtil.release(msg);
            }
        } else {
            Queue<Object> q = this.receiverQueue;
            if (q == null) {
                q = Queues.unbounded().get();
                this.receiverQueue = q;
            }
            if (log.isDebugEnabled()) {
                if (msg instanceof ByteBuf) {
                    ((ByteBuf)msg).touch("Buffered ByteBuf in Inbound Flux Queue");
                } else if (msg instanceof ByteBufHolder) {
                    ((ByteBufHolder)msg).touch("Buffered ByteBufHolder in Inbound Flux Queue");
                }
            }
            q.offer(msg);
            this.drainReceiver();
        }
    }

    final void onInboundComplete() {
        if (this.inboundDone) {
            return;
        }
        this.inboundDone = true;
        if (this.receiverFastpath) {
            CoreSubscriber<? super Object> receiver = this.receiver;
            if (receiver != null) {
                receiver.onComplete();
            }
            return;
        }
        this.drainReceiver();
    }

    final void onInboundError(Throwable err) {
        if (this.isCancelled() || this.inboundDone) {
            Context c = this.receiver == null ? Context.empty() : this.receiver.currentContext();
            Operators.onErrorDropped(err, c);
            return;
        }
        CoreSubscriber<? super Object> receiver = this.receiver;
        this.inboundError = err;
        this.inboundDone = true;
        if (this.channel.isActive()) {
            this.channel.close();
        }
        if (this.receiverFastpath && receiver != null) {
            this.parent.context.fireContextError(err);
            receiver.onError(err);
        } else {
            this.drainReceiver();
        }
    }

    final void terminateReceiver(Queue<?> q, CoreSubscriber<?> a) {
        Throwable ex;
        if (q != null) {
            q.clear();
        }
        if ((ex = this.inboundError) != null) {
            this.parent.context.fireContextError(ex);
            a.onError(ex);
        } else {
            a.onComplete();
        }
    }

    final void unsubscribeReceiver() {
        this.receiverDemand = 0L;
        this.receiver = null;
        if (this.isCancelled()) {
            this.parent.onInboundCancel();
        }
    }
}

