/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.http.server;

import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelDuplexHandler;
import io.micrometer.shaded.io.netty.channel.ChannelFuture;
import io.micrometer.shaded.io.netty.channel.ChannelFutureListener;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.handler.codec.DecoderResult;
import io.micrometer.shaded.io.netty.handler.codec.TooLongFrameException;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.micrometer.shaded.io.netty.handler.codec.http.FullHttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpResponse;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpStatusClass;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpUtil;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpVersion;
import io.micrometer.shaded.io.netty.handler.codec.http.LastHttpContent;
import io.micrometer.shaded.io.netty.util.ReferenceCountUtil;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.ipc.netty.channel.ContextHandler;
import io.micrometer.shaded.reactor.ipc.netty.http.server.HttpServerOperations;
import io.micrometer.shaded.reactor.util.concurrent.Queues;
import java.util.Queue;

final class HttpServerHandler
extends ChannelDuplexHandler
implements Runnable {
    static final String MULTIPART_PREFIX = "multipart";
    final ContextHandler<?> parentContext;
    boolean persistentConnection = true;
    int pendingResponses;
    Queue<Object> pipelined;
    ChannelHandlerContext ctx;
    boolean overflow;
    boolean mustRecycleEncoder;

    HttpServerHandler(ContextHandler<?> parentContext) {
        this.parentContext = parentContext;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.ctx = ctx;
        if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug("New http connection, requesting read");
        }
        ctx.read();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            DecoderResult decoderResult = request.decoderResult();
            if (decoderResult.isFailure()) {
                Throwable cause = decoderResult.cause();
                HttpServerOperations.log.debug("Decoding failed: " + msg + " : ", cause);
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_0, cause instanceof TooLongFrameException ? HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE : HttpResponseStatus.BAD_REQUEST);
                response.headers().setInt(HttpHeaderNames.CONTENT_LENGTH, 0).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                ctx.writeAndFlush(response).addListener(ChannelFutureListener.CLOSE);
                return;
            }
            if (this.persistentConnection) {
                ++this.pendingResponses;
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug("Increasing pending responses, now {}", this.pendingResponses);
                }
            } else {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug("dropping pipelined HTTP request, previous response requested connection close");
                }
                ReferenceCountUtil.release(msg);
                return;
            }
            this.persistentConnection = HttpUtil.isKeepAlive(request);
            if (this.pendingResponses > 1) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug("buffering pipelined HTTP request, pending response count: {}, queue: {}", this.pendingResponses, this.pipelined != null ? this.pipelined.size() : 0);
                }
                this.overflow = true;
                this.doPipeline(ctx, msg);
                return;
            }
            this.overflow = false;
            this.parentContext.createOperations(ctx.channel(), msg);
            if (!(msg instanceof FullHttpRequest)) {
                return;
            }
        } else {
            if (this.persistentConnection && this.pendingResponses == 0) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug("Dropped HTTP content, Since response has been sent already:{}", msg);
                }
                if (msg instanceof LastHttpContent) {
                    ctx.fireChannelRead(msg);
                } else {
                    ReferenceCountUtil.release(msg);
                }
                ctx.read();
                return;
            }
            if (this.overflow) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug("buffering pipelined HTTP content, pending response count: {}, pending pipeline:{}", this.pendingResponses, this.pipelined != null ? this.pipelined.size() : 0);
                }
                this.doPipeline(ctx, msg);
                return;
            }
        }
        ctx.fireChannelRead(msg);
    }

    void doPipeline(ChannelHandlerContext ctx, Object msg) {
        if (this.pipelined == null) {
            this.pipelined = Queues.unbounded().get();
        }
        if (!this.pipelined.offer(msg)) {
            ctx.fireExceptionCaught(Exceptions.failWithOverflow());
        }
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            this.trackResponse(response);
            if (!HttpUtil.isKeepAlive(response) || !HttpServerHandler.isSelfDefinedMessageLength(response)) {
                this.pendingResponses = 0;
                this.persistentConnection = false;
            }
            if (!this.shouldKeepAlive()) {
                HttpUtil.setKeepAlive(response, false);
            }
            if (response.status().equals(HttpResponseStatus.CONTINUE)) {
                ctx.write(msg, promise);
                return;
            }
        }
        if (msg instanceof LastHttpContent) {
            if (!this.shouldKeepAlive()) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug("Detected non persistent http connection, preparing to close", this.pendingResponses);
                }
                promise.addListener(ChannelFutureListener.CLOSE);
                ctx.write(msg, promise);
                return;
            }
            ctx.write(msg, promise).addListener(new TerminateHttpHandler(ctx.channel()));
            if (!this.persistentConnection) {
                return;
            }
            if (this.mustRecycleEncoder) {
                this.mustRecycleEncoder = false;
                --this.pendingResponses;
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug("Decreasing pending responses, now {}", this.pendingResponses);
                }
            }
            if (this.pipelined != null && !this.pipelined.isEmpty()) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug("draining next pipelined request, pending response count: {}, queued: {}", this.pendingResponses, this.pipelined.size());
                }
                ctx.executor().execute(this);
            } else {
                ctx.read();
            }
            return;
        }
        ctx.write(msg, promise);
    }

    void trackResponse(HttpResponse response) {
        this.mustRecycleEncoder = !HttpServerHandler.isInformational(response);
    }

    @Override
    public void run() {
        Object next;
        boolean nextRequest = false;
        while ((next = this.pipelined.peek()) != null) {
            if (next instanceof HttpRequest) {
                if (nextRequest || !this.persistentConnection) {
                    return;
                }
                nextRequest = true;
                this.parentContext.createOperations(this.ctx.channel(), next);
                if (!(next instanceof FullHttpRequest)) {
                    this.pipelined.poll();
                    continue;
                }
            }
            this.ctx.fireChannelRead(this.pipelined.poll());
        }
        this.overflow = false;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.discard();
    }

    final void discard() {
        if (this.pipelined != null && !this.pipelined.isEmpty()) {
            Object o;
            while ((o = this.pipelined.poll()) != null) {
                ReferenceCountUtil.release(o);
            }
        }
    }

    boolean shouldKeepAlive() {
        return this.pendingResponses != 0 && this.persistentConnection;
    }

    static boolean isSelfDefinedMessageLength(HttpResponse response) {
        return HttpUtil.isContentLengthSet(response) || HttpUtil.isTransferEncodingChunked(response) || HttpServerHandler.isMultipart(response) || HttpServerHandler.isInformational(response);
    }

    static boolean isInformational(HttpResponse response) {
        return response.status().codeClass() == HttpStatusClass.INFORMATIONAL;
    }

    static boolean isMultipart(HttpResponse response) {
        String contentType = response.headers().get(HttpHeaderNames.CONTENT_TYPE);
        return contentType != null && contentType.regionMatches(true, 0, MULTIPART_PREFIX, 0, MULTIPART_PREFIX.length());
    }

    static final class TerminateHttpHandler
    implements ChannelFutureListener {
        final Channel channel;

        TerminateHttpHandler(Channel channel) {
            this.channel = channel;
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            HttpServerOperations.cleanHandlerTerminate(this.channel);
        }
    }
}

