/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.udp;

import io.micrometer.shaded.io.netty.channel.ChannelFuture;
import io.micrometer.shaded.io.netty.channel.socket.DatagramChannel;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.FutureMono;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.netty.udp.UdpInbound;
import io.micrometer.shaded.reactor.netty.udp.UdpOutbound;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;

final class UdpOperations
extends ChannelOperations<UdpInbound, UdpOutbound>
implements UdpInbound,
UdpOutbound {
    final DatagramChannel datagramChannel;
    static final Logger log = Loggers.getLogger(UdpOperations.class);

    UdpOperations(Connection c, ConnectionObserver listener) {
        super(c, listener);
        this.datagramChannel = (DatagramChannel)c.channel();
    }

    @Override
    public Mono<Void> join(InetAddress multicastAddress, NetworkInterface iface) {
        if (null == iface && null != this.datagramChannel.config().getNetworkInterface()) {
            iface = this.datagramChannel.config().getNetworkInterface();
        }
        ChannelFuture future = null != iface ? this.datagramChannel.joinGroup(new InetSocketAddress(multicastAddress, this.datagramChannel.localAddress().getPort()), iface) : this.datagramChannel.joinGroup(multicastAddress);
        return FutureMono.from(future).doOnSuccess(v -> log.info(ReactorNetty.format(future.channel(), "JOIN {}"), multicastAddress));
    }

    @Override
    public Mono<Void> leave(InetAddress multicastAddress, NetworkInterface iface) {
        if (null == iface && null != this.datagramChannel.config().getNetworkInterface()) {
            iface = this.datagramChannel.config().getNetworkInterface();
        }
        ChannelFuture future = null != iface ? this.datagramChannel.leaveGroup(new InetSocketAddress(multicastAddress, this.datagramChannel.localAddress().getPort()), iface) : this.datagramChannel.leaveGroup(multicastAddress);
        return FutureMono.from(future).doOnSuccess(v -> log.info(ReactorNetty.format(future.channel(), "JOIN {}"), multicastAddress));
    }
}

