/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd.internal;

import io.micrometer.shaded.reactor.core.publisher.DirectProcessor;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class BufferingFlux {
    private BufferingFlux() {
    }

    public static Flux<String> create(Flux<String> source, String delimiter, int maxByteArraySize, long maxMillisecondsBetweenEmits) {
        return Flux.defer(() -> {
            int delimiterSize = delimiter.getBytes().length;
            AtomicInteger byteSize = new AtomicInteger(0);
            AtomicLong lastTime = new AtomicLong(0L);
            DirectProcessor intervalEnd = DirectProcessor.create();
            Flux<String> hearbeat = Flux.interval(Duration.ofMillis(maxMillisecondsBetweenEmits)).map(l -> "").takeUntilOther(intervalEnd);
            Flux<String> sourceWithEmptyStringKeepAlive = source.doOnTerminate(intervalEnd::onComplete).mergeWith(hearbeat);
            return sourceWithEmptyStringKeepAlive.bufferUntil(line -> {
                int projectedBytes;
                long diff;
                int bytesLength = line.getBytes().length;
                long now = System.currentTimeMillis();
                long last = lastTime.getAndSet(now);
                if (last != 0L && (diff = now - last) > maxMillisecondsBetweenEmits && byteSize.get() > 0) {
                    byteSize.set(bytesLength);
                    return true;
                }
                int additionalBytes = bytesLength;
                if (additionalBytes > 0 && byteSize.get() > 0) {
                    additionalBytes += delimiterSize;
                }
                if ((projectedBytes = byteSize.addAndGet(additionalBytes)) > maxByteArraySize) {
                    byteSize.set(bytesLength);
                    return true;
                }
                return false;
            }, true).map(lines -> {
                lines.removeIf(String::isEmpty);
                return String.join((CharSequence)delimiter, lines);
            });
        });
    }
}

