/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.io.netty.handler.codec.http2;

import io.micrometer.shaded.io.netty.buffer.ByteBufAllocator;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelConfig;
import io.micrometer.shaded.io.netty.channel.ChannelFuture;
import io.micrometer.shaded.io.netty.channel.ChannelFutureListener;
import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelId;
import io.micrometer.shaded.io.netty.channel.ChannelMetadata;
import io.micrometer.shaded.io.netty.channel.ChannelOutboundBuffer;
import io.micrometer.shaded.io.netty.channel.ChannelPipeline;
import io.micrometer.shaded.io.netty.channel.ChannelProgressivePromise;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.channel.DefaultChannelConfig;
import io.micrometer.shaded.io.netty.channel.DefaultChannelPipeline;
import io.micrometer.shaded.io.netty.channel.EventLoop;
import io.micrometer.shaded.io.netty.channel.MessageSizeEstimator;
import io.micrometer.shaded.io.netty.channel.RecvByteBufAllocator;
import io.micrometer.shaded.io.netty.channel.VoidChannelPromise;
import io.micrometer.shaded.io.netty.channel.WriteBufferWaterMark;
import io.micrometer.shaded.io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2CodecUtil;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2DataFrame;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2Error;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2Exception;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2Frame;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2FrameCodec;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2FrameStream;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2FrameStreamException;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2HeadersFrame;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2Settings;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2SettingsFrame;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2Stream;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2StreamChannel;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2StreamChannelId;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2StreamFrame;
import io.micrometer.shaded.io.netty.util.DefaultAttributeMap;
import io.micrometer.shaded.io.netty.util.ReferenceCountUtil;
import io.micrometer.shaded.io.netty.util.internal.StringUtil;
import io.micrometer.shaded.io.netty.util.internal.ThrowableUtil;
import io.micrometer.shaded.io.netty.util.internal.logging.InternalLogger;
import io.micrometer.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;

public class Http2MultiplexCodec
extends Http2FrameCodec {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2StreamChannel.class);
    private static final ChannelFutureListener CHILD_CHANNEL_REGISTRATION_LISTENER = new ChannelFutureListener(){

        @Override
        public void operationComplete(ChannelFuture future) {
            Http2MultiplexCodec.registerDone(future);
        }
    };
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final ClosedChannelException CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), DefaultHttp2StreamChannel.Http2ChannelUnsafe.class, "write(...)");
    private static final int MIN_HTTP2_FRAME_SIZE = 9;
    private final ChannelHandler inboundStreamHandler;
    private final ChannelHandler upgradeStreamHandler;
    private int initialOutboundStreamWindow = 65535;
    private boolean parentReadInProgress;
    private int idCount;
    private DefaultHttp2StreamChannel head;
    private DefaultHttp2StreamChannel tail;
    volatile ChannelHandlerContext ctx;

    Http2MultiplexCodec(Http2ConnectionEncoder encoder, Http2ConnectionDecoder decoder, Http2Settings initialSettings, ChannelHandler inboundStreamHandler, ChannelHandler upgradeStreamHandler) {
        super(encoder, decoder, initialSettings);
        this.inboundStreamHandler = inboundStreamHandler;
        this.upgradeStreamHandler = upgradeStreamHandler;
    }

    @Override
    public void onHttpClientUpgrade() throws Http2Exception {
        if (this.upgradeStreamHandler == null) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Client is misconfigured for upgrade requests", new Object[0]);
        }
        super.onHttpClientUpgrade();
        Http2MultiplexCodecStream codecStream = this.newStream();
        codecStream.setStreamAndProperty(this.streamKey, this.connection().stream(1));
        this.onHttp2UpgradeStreamInitialized(this.ctx, codecStream);
    }

    private static void registerDone(ChannelFuture future) {
        if (!future.isSuccess()) {
            Channel childChannel = future.channel();
            if (childChannel.isRegistered()) {
                childChannel.close();
            } else {
                childChannel.unsafe().closeForcibly();
            }
        }
    }

    @Override
    public final void handlerAdded0(ChannelHandlerContext ctx) throws Exception {
        if (ctx.executor() != ctx.channel().eventLoop()) {
            throw new IllegalStateException("EventExecutor must be EventLoop of Channel");
        }
        this.ctx = ctx;
    }

    @Override
    public final void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved0(ctx);
        DefaultHttp2StreamChannel ch = this.head;
        while (ch != null) {
            DefaultHttp2StreamChannel curr = ch;
            ch = curr.next;
            curr.previous = null;
            curr.next = null;
        }
        this.tail = null;
        this.head = null;
    }

    @Override
    Http2MultiplexCodecStream newStream() {
        return new Http2MultiplexCodecStream();
    }

    @Override
    final void onHttp2Frame(ChannelHandlerContext ctx, Http2Frame frame) {
        if (frame instanceof Http2StreamFrame) {
            Http2StreamFrame streamFrame = (Http2StreamFrame)frame;
            ((Http2MultiplexCodecStream)streamFrame.stream()).channel.fireChildRead(streamFrame);
        } else if (frame instanceof Http2GoAwayFrame) {
            this.onHttp2GoAwayFrame(ctx, (Http2GoAwayFrame)frame);
            ctx.fireChannelRead(frame);
        } else if (frame instanceof Http2SettingsFrame) {
            Http2Settings settings = ((Http2SettingsFrame)frame).settings();
            if (settings.initialWindowSize() != null) {
                this.initialOutboundStreamWindow = settings.initialWindowSize();
            }
            ctx.fireChannelRead(frame);
        } else {
            ctx.fireChannelRead(frame);
        }
    }

    private void onHttp2UpgradeStreamInitialized(ChannelHandlerContext ctx, Http2MultiplexCodecStream stream) {
        assert (stream.state() == Http2Stream.State.HALF_CLOSED_LOCAL);
        DefaultHttp2StreamChannel ch = new DefaultHttp2StreamChannel(stream, true);
        ch.outboundClosed = true;
        ch.pipeline().addLast(this.upgradeStreamHandler);
        ChannelFuture future = ctx.channel().eventLoop().register(ch);
        if (future.isDone()) {
            Http2MultiplexCodec.registerDone(future);
        } else {
            future.addListener(CHILD_CHANNEL_REGISTRATION_LISTENER);
        }
    }

    @Override
    final void onHttp2StreamStateChanged(ChannelHandlerContext ctx, Http2FrameStream stream) {
        Http2MultiplexCodecStream s = (Http2MultiplexCodecStream)stream;
        switch (stream.state()) {
            case HALF_CLOSED_REMOTE: 
            case OPEN: {
                if (s.channel != null) break;
                ChannelFuture future = ctx.channel().eventLoop().register(new DefaultHttp2StreamChannel(s, false));
                if (future.isDone()) {
                    Http2MultiplexCodec.registerDone(future);
                    break;
                }
                future.addListener(CHILD_CHANNEL_REGISTRATION_LISTENER);
                break;
            }
            case CLOSED: {
                DefaultHttp2StreamChannel channel = s.channel;
                if (channel == null) break;
                channel.streamClosed();
                break;
            }
        }
    }

    @Override
    final void onHttp2StreamWritabilityChanged(ChannelHandlerContext ctx, Http2FrameStream stream, boolean writable) {
        ((Http2MultiplexCodecStream)stream).channel.writabilityChanged(writable);
    }

    final Http2StreamChannel newOutboundStream() {
        return new DefaultHttp2StreamChannel(this.newStream(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void onHttp2FrameStreamException(ChannelHandlerContext ctx, Http2FrameStreamException cause) {
        Http2FrameStream stream = cause.stream();
        DefaultHttp2StreamChannel childChannel = ((Http2MultiplexCodecStream)stream).channel;
        try {
            childChannel.pipeline().fireExceptionCaught(cause.getCause());
        }
        finally {
            childChannel.unsafe().closeForcibly();
        }
    }

    private boolean isChildChannelInReadPendingQueue(DefaultHttp2StreamChannel childChannel) {
        return childChannel.previous != null || childChannel.next != null || this.head == childChannel;
    }

    final void tryAddChildChannelToReadPendingQueue(DefaultHttp2StreamChannel childChannel) {
        if (!this.isChildChannelInReadPendingQueue(childChannel)) {
            this.addChildChannelToReadPendingQueue(childChannel);
        }
    }

    final void addChildChannelToReadPendingQueue(DefaultHttp2StreamChannel childChannel) {
        if (this.tail == null) {
            assert (this.head == null);
            this.tail = this.head = childChannel;
        } else {
            childChannel.previous = this.tail;
            this.tail.next = childChannel;
            this.tail = childChannel;
        }
    }

    private void tryRemoveChildChannelFromReadPendingQueue(DefaultHttp2StreamChannel childChannel) {
        if (this.isChildChannelInReadPendingQueue(childChannel)) {
            this.removeChildChannelFromReadPendingQueue(childChannel);
        }
    }

    private void removeChildChannelFromReadPendingQueue(DefaultHttp2StreamChannel childChannel) {
        DefaultHttp2StreamChannel previous = childChannel.previous;
        if (childChannel.next != null) {
            childChannel.next.previous = previous;
        } else {
            this.tail = this.tail.previous;
        }
        if (previous != null) {
            previous.next = childChannel.next;
        } else {
            this.head = this.head.next;
        }
        childChannel.previous = null;
        childChannel.next = null;
    }

    private void onHttp2GoAwayFrame(ChannelHandlerContext ctx, final Http2GoAwayFrame goAwayFrame) {
        try {
            this.forEachActiveStream(new Http2FrameStreamVisitor(){

                @Override
                public boolean visit(Http2FrameStream stream) {
                    int streamId = stream.id();
                    DefaultHttp2StreamChannel childChannel = ((Http2MultiplexCodecStream)stream).channel;
                    if (streamId > goAwayFrame.lastStreamId() && Http2MultiplexCodec.this.connection().local().isValidStreamId(streamId)) {
                        childChannel.pipeline().fireUserEventTriggered(goAwayFrame.retainedDuplicate());
                    }
                    return true;
                }
            });
        }
        catch (Http2Exception e) {
            ctx.fireExceptionCaught(e);
            ctx.close();
        }
    }

    @Override
    public final void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        try {
            this.onChannelReadComplete(ctx);
        }
        finally {
            this.parentReadInProgress = false;
            this.head = null;
            this.tail = null;
            this.flush0(ctx);
        }
        this.channelReadComplete0(ctx);
    }

    @Override
    public final void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.parentReadInProgress = true;
        super.channelRead(ctx, msg);
    }

    final void onChannelReadComplete(ChannelHandlerContext ctx) {
        DefaultHttp2StreamChannel current = this.head;
        while (current != null) {
            DefaultHttp2StreamChannel childChannel = current;
            current = current.next;
            childChannel.previous = null;
            childChannel.next = null;
            childChannel.fireChildReadComplete();
        }
    }

    void flush0(ChannelHandlerContext ctx) {
        this.flush(ctx);
    }

    boolean onBytesConsumed(ChannelHandlerContext ctx, Http2FrameStream stream, int bytes) throws Http2Exception {
        return this.consumeBytes(stream.id(), bytes);
    }

    private boolean initialWritability(Http2FrameCodec.DefaultHttp2FrameStream stream) {
        return !Http2CodecUtil.isStreamIdValid(stream.id()) || this.isWritable(stream);
    }

    private final class DefaultHttp2StreamChannel
    extends DefaultAttributeMap
    implements Http2StreamChannel {
        private final Http2StreamChannelConfig config = new Http2StreamChannelConfig(this);
        private final Http2ChannelUnsafe unsafe = new Http2ChannelUnsafe();
        private final ChannelId channelId;
        private final ChannelPipeline pipeline;
        private final Http2FrameCodec.DefaultHttp2FrameStream stream;
        private final ChannelPromise closePromise;
        private final boolean outbound;
        private volatile boolean registered;
        private volatile boolean writable;
        private boolean outboundClosed;
        private boolean readInProgress;
        private Queue<Object> inboundBuffer;
        private boolean firstFrameWritten;
        DefaultHttp2StreamChannel next;
        DefaultHttp2StreamChannel previous;

        DefaultHttp2StreamChannel(Http2FrameCodec.DefaultHttp2FrameStream stream, boolean outbound) {
            this.stream = stream;
            this.outbound = outbound;
            this.writable = Http2MultiplexCodec.this.initialWritability(stream);
            ((Http2MultiplexCodecStream)stream).channel = this;
            this.pipeline = new DefaultChannelPipeline(this){

                @Override
                protected void incrementPendingOutboundBytes(long size) {
                }

                @Override
                protected void decrementPendingOutboundBytes(long size) {
                }
            };
            this.closePromise = this.pipeline.newPromise();
            this.channelId = new Http2StreamChannelId(this.parent().id(), ++Http2MultiplexCodec.this.idCount);
        }

        @Override
        public Http2FrameStream stream() {
            return this.stream;
        }

        void streamClosed() {
            this.unsafe.readEOS();
            this.unsafe.doBeginRead();
        }

        @Override
        public ChannelMetadata metadata() {
            return METADATA;
        }

        @Override
        public ChannelConfig config() {
            return this.config;
        }

        @Override
        public boolean isOpen() {
            return !this.closePromise.isDone();
        }

        @Override
        public boolean isActive() {
            return this.isOpen();
        }

        @Override
        public boolean isWritable() {
            return this.writable;
        }

        @Override
        public ChannelId id() {
            return this.channelId;
        }

        @Override
        public EventLoop eventLoop() {
            return this.parent().eventLoop();
        }

        @Override
        public Channel parent() {
            return Http2MultiplexCodec.this.ctx.channel();
        }

        @Override
        public boolean isRegistered() {
            return this.registered;
        }

        @Override
        public SocketAddress localAddress() {
            return this.parent().localAddress();
        }

        @Override
        public SocketAddress remoteAddress() {
            return this.parent().remoteAddress();
        }

        @Override
        public ChannelFuture closeFuture() {
            return this.closePromise;
        }

        @Override
        public long bytesBeforeUnwritable() {
            return this.config().getWriteBufferHighWaterMark();
        }

        @Override
        public long bytesBeforeWritable() {
            return 0L;
        }

        @Override
        public Channel.Unsafe unsafe() {
            return this.unsafe;
        }

        @Override
        public ChannelPipeline pipeline() {
            return this.pipeline;
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.config().getAllocator();
        }

        @Override
        public Channel read() {
            this.pipeline().read();
            return this;
        }

        @Override
        public Channel flush() {
            this.pipeline().flush();
            return this;
        }

        @Override
        public ChannelFuture bind(SocketAddress localAddress) {
            return this.pipeline().bind(localAddress);
        }

        @Override
        public ChannelFuture connect(SocketAddress remoteAddress) {
            return this.pipeline().connect(remoteAddress);
        }

        @Override
        public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
            return this.pipeline().connect(remoteAddress, localAddress);
        }

        @Override
        public ChannelFuture disconnect() {
            return this.pipeline().disconnect();
        }

        @Override
        public ChannelFuture close() {
            return this.pipeline().close();
        }

        @Override
        public ChannelFuture deregister() {
            return this.pipeline().deregister();
        }

        @Override
        public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
            return this.pipeline().bind(localAddress, promise);
        }

        @Override
        public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
            return this.pipeline().connect(remoteAddress, promise);
        }

        @Override
        public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            return this.pipeline().connect(remoteAddress, localAddress, promise);
        }

        @Override
        public ChannelFuture disconnect(ChannelPromise promise) {
            return this.pipeline().disconnect(promise);
        }

        @Override
        public ChannelFuture close(ChannelPromise promise) {
            return this.pipeline().close(promise);
        }

        @Override
        public ChannelFuture deregister(ChannelPromise promise) {
            return this.pipeline().deregister(promise);
        }

        @Override
        public ChannelFuture write(Object msg) {
            return this.pipeline().write(msg);
        }

        @Override
        public ChannelFuture write(Object msg, ChannelPromise promise) {
            return this.pipeline().write(msg, promise);
        }

        @Override
        public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
            return this.pipeline().writeAndFlush(msg, promise);
        }

        @Override
        public ChannelFuture writeAndFlush(Object msg) {
            return this.pipeline().writeAndFlush(msg);
        }

        @Override
        public ChannelPromise newPromise() {
            return this.pipeline().newPromise();
        }

        @Override
        public ChannelProgressivePromise newProgressivePromise() {
            return this.pipeline().newProgressivePromise();
        }

        @Override
        public ChannelFuture newSucceededFuture() {
            return this.pipeline().newSucceededFuture();
        }

        @Override
        public ChannelFuture newFailedFuture(Throwable cause) {
            return this.pipeline().newFailedFuture(cause);
        }

        @Override
        public ChannelPromise voidPromise() {
            return this.pipeline().voidPromise();
        }

        public int hashCode() {
            return this.id().hashCode();
        }

        public boolean equals(Object o) {
            return this == o;
        }

        @Override
        public int compareTo(Channel o) {
            if (this == o) {
                return 0;
            }
            return this.id().compareTo(o.id());
        }

        public String toString() {
            return this.parent().toString() + "(H2 - " + this.stream + ')';
        }

        void writabilityChanged(boolean writable) {
            assert (this.eventLoop().inEventLoop());
            if (writable != this.writable && this.isActive()) {
                this.writable = writable;
                this.pipeline().fireChannelWritabilityChanged();
            }
        }

        void fireChildRead(Http2Frame frame) {
            assert (this.eventLoop().inEventLoop());
            if (!this.isActive()) {
                ReferenceCountUtil.release(frame);
            } else if (this.readInProgress) {
                assert (this.inboundBuffer == null || this.inboundBuffer.isEmpty());
                RecvByteBufAllocator.Handle allocHandle = this.unsafe.recvBufAllocHandle();
                this.unsafe.doRead0(frame, allocHandle);
                if (allocHandle.continueReading()) {
                    Http2MultiplexCodec.this.tryAddChildChannelToReadPendingQueue(this);
                } else {
                    Http2MultiplexCodec.this.tryRemoveChildChannelFromReadPendingQueue(this);
                    this.unsafe.notifyReadComplete(allocHandle);
                }
            } else {
                if (this.inboundBuffer == null) {
                    this.inboundBuffer = new ArrayDeque<Object>(4);
                }
                this.inboundBuffer.add(frame);
            }
        }

        void fireChildReadComplete() {
            assert (this.eventLoop().inEventLoop());
            assert (this.readInProgress);
            this.unsafe.notifyReadComplete(this.unsafe.recvBufAllocHandle());
        }

        private final class Http2StreamChannelConfig
        extends DefaultChannelConfig {
            Http2StreamChannelConfig(Channel channel) {
                super(channel);
            }

            @Override
            public int getWriteBufferHighWaterMark() {
                return Math.min(DefaultHttp2StreamChannel.this.parent().config().getWriteBufferHighWaterMark(), Http2MultiplexCodec.this.initialOutboundStreamWindow);
            }

            @Override
            public int getWriteBufferLowWaterMark() {
                return Math.min(DefaultHttp2StreamChannel.this.parent().config().getWriteBufferLowWaterMark(), Http2MultiplexCodec.this.initialOutboundStreamWindow);
            }

            @Override
            public MessageSizeEstimator getMessageSizeEstimator() {
                return FlowControlledFrameSizeEstimator.INSTANCE;
            }

            @Override
            public WriteBufferWaterMark getWriteBufferWaterMark() {
                int mark = this.getWriteBufferHighWaterMark();
                return new WriteBufferWaterMark(mark, mark);
            }

            @Override
            public ChannelConfig setMessageSizeEstimator(MessageSizeEstimator estimator) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Deprecated
            public ChannelConfig setWriteBufferHighWaterMark(int writeBufferHighWaterMark) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Deprecated
            public ChannelConfig setWriteBufferLowWaterMark(int writeBufferLowWaterMark) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator allocator) {
                if (!(allocator.newHandle() instanceof RecvByteBufAllocator.ExtendedHandle)) {
                    throw new IllegalArgumentException("allocator.newHandle() must return an object of type: " + RecvByteBufAllocator.ExtendedHandle.class);
                }
                super.setRecvByteBufAllocator(allocator);
                return this;
            }
        }

        private final class Http2ChannelUnsafe
        implements Channel.Unsafe {
            private final VoidChannelPromise unsafeVoidPromise;
            private RecvByteBufAllocator.Handle recvHandle;
            private boolean writeDoneAndNoFlush;
            private boolean closeInitiated;
            private boolean readEOS;

            private Http2ChannelUnsafe() {
                this.unsafeVoidPromise = new VoidChannelPromise(DefaultHttp2StreamChannel.this, false);
            }

            @Override
            public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
                if (!promise.setUncancellable()) {
                    return;
                }
                promise.setFailure(new UnsupportedOperationException());
            }

            @Override
            public RecvByteBufAllocator.Handle recvBufAllocHandle() {
                if (this.recvHandle == null) {
                    this.recvHandle = DefaultHttp2StreamChannel.this.config().getRecvByteBufAllocator().newHandle();
                    this.recvHandle.reset(DefaultHttp2StreamChannel.this.config());
                }
                return this.recvHandle;
            }

            @Override
            public SocketAddress localAddress() {
                return DefaultHttp2StreamChannel.this.parent().unsafe().localAddress();
            }

            @Override
            public SocketAddress remoteAddress() {
                return DefaultHttp2StreamChannel.this.parent().unsafe().remoteAddress();
            }

            @Override
            public void register(EventLoop eventLoop, ChannelPromise promise) {
                if (!promise.setUncancellable()) {
                    return;
                }
                if (DefaultHttp2StreamChannel.this.registered) {
                    throw new UnsupportedOperationException("Re-register is not supported");
                }
                DefaultHttp2StreamChannel.this.registered = true;
                if (!DefaultHttp2StreamChannel.this.outbound) {
                    DefaultHttp2StreamChannel.this.pipeline().addLast(Http2MultiplexCodec.this.inboundStreamHandler);
                }
                promise.setSuccess();
                DefaultHttp2StreamChannel.this.pipeline().fireChannelRegistered();
                if (DefaultHttp2StreamChannel.this.isActive()) {
                    DefaultHttp2StreamChannel.this.pipeline().fireChannelActive();
                }
            }

            @Override
            public void bind(SocketAddress localAddress, ChannelPromise promise) {
                if (!promise.setUncancellable()) {
                    return;
                }
                promise.setFailure(new UnsupportedOperationException());
            }

            @Override
            public void disconnect(ChannelPromise promise) {
                this.close(promise);
            }

            @Override
            public void close(final ChannelPromise promise) {
                if (!promise.setUncancellable()) {
                    return;
                }
                if (this.closeInitiated) {
                    if (DefaultHttp2StreamChannel.this.closePromise.isDone()) {
                        promise.setSuccess();
                    } else if (!(promise instanceof VoidChannelPromise)) {
                        DefaultHttp2StreamChannel.this.closePromise.addListener(new ChannelFutureListener(){

                            @Override
                            public void operationComplete(ChannelFuture future) {
                                promise.setSuccess();
                            }
                        });
                    }
                    return;
                }
                this.closeInitiated = true;
                Http2MultiplexCodec.this.tryRemoveChildChannelFromReadPendingQueue(DefaultHttp2StreamChannel.this);
                boolean wasActive = DefaultHttp2StreamChannel.this.isActive();
                if (DefaultHttp2StreamChannel.this.parent().isActive() && !this.readEOS && Http2MultiplexCodec.this.connection().streamMayHaveExisted(DefaultHttp2StreamChannel.this.stream().id())) {
                    DefaultHttp2ResetFrame resetFrame = new DefaultHttp2ResetFrame(Http2Error.CANCEL).stream(DefaultHttp2StreamChannel.this.stream());
                    this.write(resetFrame, DefaultHttp2StreamChannel.this.unsafe().voidPromise());
                    this.flush();
                }
                if (DefaultHttp2StreamChannel.this.inboundBuffer != null) {
                    Object msg;
                    while ((msg = DefaultHttp2StreamChannel.this.inboundBuffer.poll()) != null) {
                        ReferenceCountUtil.release(msg);
                    }
                }
                DefaultHttp2StreamChannel.this.outboundClosed = true;
                DefaultHttp2StreamChannel.this.closePromise.setSuccess();
                promise.setSuccess();
                this.fireChannelInactiveAndDeregister(this.voidPromise(), wasActive);
            }

            @Override
            public void closeForcibly() {
                this.close(DefaultHttp2StreamChannel.this.unsafe().voidPromise());
            }

            @Override
            public void deregister(ChannelPromise promise) {
                this.fireChannelInactiveAndDeregister(promise, false);
            }

            private void fireChannelInactiveAndDeregister(final ChannelPromise promise, final boolean fireChannelInactive) {
                if (!promise.setUncancellable()) {
                    return;
                }
                if (!DefaultHttp2StreamChannel.this.registered) {
                    promise.setSuccess();
                    return;
                }
                this.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (fireChannelInactive) {
                            DefaultHttp2StreamChannel.this.pipeline.fireChannelInactive();
                        }
                        if (DefaultHttp2StreamChannel.this.registered) {
                            DefaultHttp2StreamChannel.this.registered = false;
                            DefaultHttp2StreamChannel.this.pipeline.fireChannelUnregistered();
                        }
                        Http2ChannelUnsafe.this.safeSetSuccess(promise);
                    }
                });
            }

            private void safeSetSuccess(ChannelPromise promise) {
                if (!(promise instanceof VoidChannelPromise) && !promise.trySuccess()) {
                    logger.warn("Failed to mark a promise as success because it is done already: {}", (Object)promise);
                }
            }

            private void invokeLater(Runnable task) {
                try {
                    DefaultHttp2StreamChannel.this.eventLoop().execute(task);
                }
                catch (RejectedExecutionException e) {
                    logger.warn("Can't invoke task later as EventLoop rejected it", e);
                }
            }

            @Override
            public void beginRead() {
                if (DefaultHttp2StreamChannel.this.readInProgress || !DefaultHttp2StreamChannel.this.isActive()) {
                    return;
                }
                DefaultHttp2StreamChannel.this.readInProgress = true;
                this.doBeginRead();
            }

            void doBeginRead() {
                Object message;
                if (DefaultHttp2StreamChannel.this.inboundBuffer == null || (message = DefaultHttp2StreamChannel.this.inboundBuffer.poll()) == null) {
                    if (this.readEOS) {
                        DefaultHttp2StreamChannel.this.unsafe.closeForcibly();
                    }
                } else {
                    RecvByteBufAllocator.Handle allocHandle = this.recvBufAllocHandle();
                    allocHandle.reset(DefaultHttp2StreamChannel.this.config());
                    boolean continueReading = false;
                    do {
                        this.doRead0((Http2Frame)message, allocHandle);
                    } while ((this.readEOS || (continueReading = allocHandle.continueReading())) && (message = DefaultHttp2StreamChannel.this.inboundBuffer.poll()) != null);
                    if (continueReading && Http2MultiplexCodec.this.parentReadInProgress && !this.readEOS) {
                        assert (!Http2MultiplexCodec.this.isChildChannelInReadPendingQueue(DefaultHttp2StreamChannel.this));
                        Http2MultiplexCodec.this.addChildChannelToReadPendingQueue(DefaultHttp2StreamChannel.this);
                    } else {
                        this.notifyReadComplete(allocHandle);
                    }
                }
            }

            void readEOS() {
                this.readEOS = true;
            }

            void notifyReadComplete(RecvByteBufAllocator.Handle allocHandle) {
                assert (DefaultHttp2StreamChannel.this.next == null && DefaultHttp2StreamChannel.this.previous == null);
                DefaultHttp2StreamChannel.this.readInProgress = false;
                allocHandle.readComplete();
                DefaultHttp2StreamChannel.this.pipeline().fireChannelReadComplete();
                this.flush();
                if (this.readEOS) {
                    DefaultHttp2StreamChannel.this.unsafe.closeForcibly();
                }
            }

            void doRead0(Http2Frame frame, RecvByteBufAllocator.Handle allocHandle) {
                DefaultHttp2StreamChannel.this.pipeline().fireChannelRead(frame);
                allocHandle.incMessagesRead(1);
                if (frame instanceof Http2DataFrame) {
                    int numBytesToBeConsumed = ((Http2DataFrame)frame).initialFlowControlledBytes();
                    allocHandle.attemptedBytesRead(numBytesToBeConsumed);
                    allocHandle.lastBytesRead(numBytesToBeConsumed);
                    if (numBytesToBeConsumed != 0) {
                        try {
                            this.writeDoneAndNoFlush |= Http2MultiplexCodec.this.onBytesConsumed(Http2MultiplexCodec.this.ctx, DefaultHttp2StreamChannel.this.stream, numBytesToBeConsumed);
                        }
                        catch (Http2Exception e) {
                            DefaultHttp2StreamChannel.this.pipeline().fireExceptionCaught(e);
                        }
                    }
                } else {
                    allocHandle.attemptedBytesRead(9);
                    allocHandle.lastBytesRead(9);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(Object msg, final ChannelPromise promise) {
                if (!promise.setUncancellable()) {
                    ReferenceCountUtil.release(msg);
                    return;
                }
                if (!DefaultHttp2StreamChannel.this.isActive() || DefaultHttp2StreamChannel.this.outboundClosed && (msg instanceof Http2HeadersFrame || msg instanceof Http2DataFrame)) {
                    ReferenceCountUtil.release(msg);
                    promise.setFailure(CLOSED_CHANNEL_EXCEPTION);
                    return;
                }
                try {
                    if (msg instanceof Http2StreamFrame) {
                        Http2StreamFrame frame = this.validateStreamFrame((Http2StreamFrame)msg).stream(DefaultHttp2StreamChannel.this.stream());
                        if (!DefaultHttp2StreamChannel.this.firstFrameWritten && !Http2CodecUtil.isStreamIdValid(DefaultHttp2StreamChannel.this.stream().id())) {
                            if (!(frame instanceof Http2HeadersFrame)) {
                                ReferenceCountUtil.release(frame);
                                promise.setFailure(new IllegalArgumentException("The first frame must be a headers frame. Was: " + frame.name()));
                                return;
                            }
                            DefaultHttp2StreamChannel.this.firstFrameWritten = true;
                            ChannelFuture future = this.write0(frame);
                            if (future.isDone()) {
                                this.firstWriteComplete(future, promise);
                            } else {
                                future.addListener(new ChannelFutureListener(){

                                    @Override
                                    public void operationComplete(ChannelFuture future) {
                                        Http2ChannelUnsafe.this.firstWriteComplete(future, promise);
                                    }
                                });
                            }
                            return;
                        }
                    } else {
                        String msgStr = msg.toString();
                        ReferenceCountUtil.release(msg);
                        promise.setFailure(new IllegalArgumentException("Message must be an " + StringUtil.simpleClassName(Http2StreamFrame.class) + ": " + msgStr));
                        return;
                    }
                    ChannelFuture future = this.write0(msg);
                    if (future.isDone()) {
                        this.writeComplete(future, promise);
                    } else {
                        future.addListener(new ChannelFutureListener(){

                            @Override
                            public void operationComplete(ChannelFuture future) {
                                Http2ChannelUnsafe.this.writeComplete(future, promise);
                            }
                        });
                    }
                }
                catch (Throwable t) {
                    promise.tryFailure(t);
                }
                finally {
                    this.writeDoneAndNoFlush = true;
                }
            }

            private void firstWriteComplete(ChannelFuture future, ChannelPromise promise) {
                Throwable cause = future.cause();
                if (cause == null) {
                    DefaultHttp2StreamChannel.this.writabilityChanged(Http2MultiplexCodec.this.isWritable(DefaultHttp2StreamChannel.this.stream));
                    promise.setSuccess();
                } else {
                    this.closeForcibly();
                    promise.setFailure(this.wrapStreamClosedError(cause));
                }
            }

            private void writeComplete(ChannelFuture future, ChannelPromise promise) {
                Throwable cause = future.cause();
                if (cause == null) {
                    promise.setSuccess();
                } else {
                    Throwable error = this.wrapStreamClosedError(cause);
                    if (error instanceof ClosedChannelException) {
                        if (DefaultHttp2StreamChannel.this.config.isAutoClose()) {
                            this.closeForcibly();
                        } else {
                            DefaultHttp2StreamChannel.this.outboundClosed = true;
                        }
                    }
                    promise.setFailure(error);
                }
            }

            private Throwable wrapStreamClosedError(Throwable cause) {
                if (cause instanceof Http2Exception && ((Http2Exception)cause).error() == Http2Error.STREAM_CLOSED) {
                    return new ClosedChannelException().initCause(cause);
                }
                return cause;
            }

            private Http2StreamFrame validateStreamFrame(Http2StreamFrame frame) {
                if (frame.stream() != null && frame.stream() != DefaultHttp2StreamChannel.this.stream) {
                    String msgString = frame.toString();
                    ReferenceCountUtil.release(frame);
                    throw new IllegalArgumentException("Stream " + frame.stream() + " must not be set on the frame: " + msgString);
                }
                return frame;
            }

            private ChannelFuture write0(Object msg) {
                ChannelPromise promise = Http2MultiplexCodec.this.ctx.newPromise();
                Http2MultiplexCodec.this.write(Http2MultiplexCodec.this.ctx, msg, promise);
                return promise;
            }

            @Override
            public void flush() {
                if (!this.writeDoneAndNoFlush || Http2MultiplexCodec.this.parentReadInProgress) {
                    return;
                }
                try {
                    Http2MultiplexCodec.this.flush0(Http2MultiplexCodec.this.ctx);
                }
                finally {
                    this.writeDoneAndNoFlush = false;
                }
            }

            @Override
            public ChannelPromise voidPromise() {
                return this.unsafeVoidPromise;
            }

            @Override
            public ChannelOutboundBuffer outboundBuffer() {
                return null;
            }
        }
    }

    static class Http2MultiplexCodecStream
    extends Http2FrameCodec.DefaultHttp2FrameStream {
        DefaultHttp2StreamChannel channel;

        Http2MultiplexCodecStream() {
        }
    }

    private static final class FlowControlledFrameSizeEstimator
    implements MessageSizeEstimator {
        static final FlowControlledFrameSizeEstimator INSTANCE = new FlowControlledFrameSizeEstimator();
        static final MessageSizeEstimator.Handle HANDLE_INSTANCE = new MessageSizeEstimator.Handle(){

            @Override
            public int size(Object msg) {
                return msg instanceof Http2DataFrame ? (int)Math.min(Integer.MAX_VALUE, (long)((Http2DataFrame)msg).initialFlowControlledBytes() + 9L) : 9;
            }
        };

        private FlowControlledFrameSizeEstimator() {
        }

        @Override
        public MessageSizeEstimator.Handle newHandle() {
            return HANDLE_INSTANCE;
        }
    }
}

