/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.AssemblyOp;
import io.micrometer.shaded.reactor.core.publisher.ConnectableFlux;
import io.micrometer.shaded.reactor.core.publisher.FluxOnAssembly;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.util.function.Consumer;

final class ConnectableFluxOnAssembly<T>
extends ConnectableFlux<T>
implements Fuseable,
AssemblyOp,
Scannable {
    final ConnectableFlux<T> source;
    final FluxOnAssembly.AssemblySnapshotException stacktrace;

    ConnectableFluxOnAssembly(ConnectableFlux<T> source) {
        this.source = source;
        this.stacktrace = new FluxOnAssembly.AssemblySnapshotException();
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        FluxOnAssembly.subscribe(actual, this.source, this.stacktrace);
    }

    @Override
    public void connect(Consumer<? super Disposable> cancelSupport) {
        this.source.connect(cancelSupport);
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.ACTUAL_METADATA) {
            return !this.stacktrace.checkpointed;
        }
        return null;
    }

    @Override
    public String stepName() {
        return this.stacktrace.operatorAssemblyInformation();
    }

    @Override
    public String toString() {
        return this.stacktrace.operatorAssemblyInformation();
    }
}

