/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.publisher.FluxMapFuseable;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoOperator;
import java.util.Objects;
import java.util.function.Function;

final class MonoMapFuseable<T, R>
extends MonoOperator<T, R>
implements Fuseable {
    final Function<? super T, ? extends R> mapper;

    MonoMapFuseable(Mono<? extends T> source, Function<? super T, ? extends R> mapper) {
        super(source);
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    @Override
    public void subscribe(CoreSubscriber<? super R> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)actual;
            this.source.subscribe(new FluxMapFuseable.MapFuseableConditionalSubscriber<T, R>(cs, this.mapper));
            return;
        }
        this.source.subscribe(new FluxMapFuseable.MapFuseableSubscriber<T, R>(actual, this.mapper));
    }
}

