/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.resources;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.EventLoopGroup;
import io.micrometer.shaded.io.netty.channel.pool.ChannelHealthChecker;
import io.micrometer.shaded.io.netty.channel.pool.ChannelPool;
import io.micrometer.shaded.io.netty.channel.pool.ChannelPoolHandler;
import io.micrometer.shaded.io.netty.util.AttributeKey;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.micrometer.shaded.io.netty.util.concurrent.Promise;
import io.micrometer.shaded.io.netty.util.internal.PlatformDependent;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoProcessor;
import io.micrometer.shaded.reactor.core.publisher.MonoSink;
import io.micrometer.shaded.reactor.core.scheduler.Schedulers;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.BootstrapHandlers;
import io.micrometer.shaded.reactor.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.netty.resources.ConnectionProvider;
import io.micrometer.shaded.reactor.netty.resources.NewConnectionProvider;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import io.micrometer.shaded.reactor.util.annotation.NonNull;
import io.micrometer.shaded.reactor.util.concurrent.Queues;
import io.micrometer.shaded.reactor.util.context.Context;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class PooledConnectionProvider
implements ConnectionProvider {
    final ConcurrentMap<PoolKey, Pool> channelPools;
    final String name;
    final PoolFactory poolFactory;
    final int maxConnections;
    static final Logger log = Loggers.getLogger(PooledConnectionProvider.class);
    static final AttributeKey<ConnectionObserver> OWNER = AttributeKey.valueOf("connectionOwner");

    PooledConnectionProvider(String name, PoolFactory poolFactory) {
        this.name = name;
        this.poolFactory = poolFactory;
        this.channelPools = PlatformDependent.newConcurrentHashMap();
        this.maxConnections = -1;
    }

    PooledConnectionProvider(String name, PoolFactory poolFactory, int maxConnections) {
        this.name = name;
        this.poolFactory = poolFactory;
        this.channelPools = PlatformDependent.newConcurrentHashMap();
        this.maxConnections = maxConnections;
    }

    @Override
    public void disposeWhen(@NonNull SocketAddress address) {
        List<Map.Entry> toDispose = this.channelPools.entrySet().stream().filter(p -> this.compareAddresses(((PoolKey)p.getKey()).holder, address)).collect(Collectors.toList());
        toDispose.forEach(e -> {
            if (this.channelPools.remove(e.getKey(), e.getValue())) {
                if (log.isDebugEnabled()) {
                    log.debug("Disposing pool for {}", ((PoolKey)e.getKey()).fqdn);
                }
                ((Pool)e.getValue()).pool.close();
            }
        });
    }

    private boolean compareAddresses(SocketAddress origin, SocketAddress target) {
        if (origin.equals(target)) {
            return true;
        }
        if (origin instanceof InetSocketAddress && target instanceof InetSocketAddress) {
            InetSocketAddress isaOrigin = (InetSocketAddress)origin;
            InetSocketAddress isaTarget = (InetSocketAddress)target;
            InetAddress iaTarget = isaTarget.getAddress();
            return iaTarget != null && iaTarget.isAnyLocalAddress() && isaOrigin.getPort() == isaTarget.getPort();
        }
        return false;
    }

    public Mono<Connection> acquire(Bootstrap b) {
        return Mono.create(sink -> {
            Pool pool;
            Bootstrap bootstrap = b.clone();
            ChannelOperations.OnSetup opsFactory = BootstrapHandlers.channelOperationFactory(bootstrap);
            ConnectionObserver obs = BootstrapHandlers.connectionObserver(bootstrap);
            NewConnectionProvider.convertLazyRemoteAddress(bootstrap);
            ChannelHandler handler = bootstrap.config().handler();
            PoolKey holder = new PoolKey(bootstrap.config().remoteAddress(), handler != null ? handler.hashCode() : -1);
            while ((pool = (Pool)this.channelPools.get(holder)) == null) {
                pool = new Pool(bootstrap, this.poolFactory, opsFactory);
                if (this.channelPools.putIfAbsent(holder, pool) == null) {
                    if (!log.isDebugEnabled()) break;
                    log.debug("Creating new client pool [{}] for {}", this.name, bootstrap.config().remoteAddress());
                    break;
                }
                pool.close();
            }
            PooledConnectionProvider.disposableAcquire(sink, obs, pool, false);
        });
    }

    @Override
    public Mono<Void> disposeLater() {
        return Mono.fromRunnable(() -> {
            for (PoolKey key : this.channelPools.keySet()) {
                Pool pool = (Pool)this.channelPools.remove(key);
                if (pool == null) continue;
                pool.close();
            }
        }).subscribeOn(Schedulers.elastic());
    }

    @Override
    public boolean isDisposed() {
        return this.channelPools.isEmpty() || this.channelPools.values().stream().allMatch(AtomicBoolean::get);
    }

    @Override
    public int maxConnections() {
        return this.maxConnections;
    }

    public String toString() {
        return "PooledConnectionProvider {name=" + this.name + ", poolFactory=" + this.poolFactory + '}';
    }

    static void disposableAcquire(MonoSink<Connection> sink, ConnectionObserver obs, Pool pool, boolean retried) {
        Future<Channel> f = pool.acquire();
        DisposableAcquire disposableAcquire = new DisposableAcquire(sink, f, pool, obs, retried);
        f.addListener(disposableAcquire);
        sink.onCancel(disposableAcquire);
    }

    static final class PoolKey {
        final SocketAddress holder;
        final int pipelineKey;
        final String fqdn;

        PoolKey(SocketAddress holder, int pipelineKey) {
            this.holder = holder;
            this.fqdn = holder instanceof InetSocketAddress ? holder.toString() : null;
            this.pipelineKey = pipelineKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PoolKey poolKey = (PoolKey)o;
            return this.pipelineKey == poolKey.pipelineKey && Objects.equals(this.holder, poolKey.holder) && Objects.equals(this.fqdn, poolKey.fqdn);
        }

        public int hashCode() {
            return Objects.hash(this.holder, this.pipelineKey, this.fqdn);
        }
    }

    static final class DisposableAcquire
    implements Disposable,
    GenericFutureListener<Future<Channel>>,
    ConnectionObserver,
    Runnable {
        final Future<Channel> f;
        final MonoSink<Connection> sink;
        final Pool pool;
        final ConnectionObserver obs;
        final boolean retried;

        DisposableAcquire(MonoSink<Connection> sink, Future<Channel> future, Pool pool, ConnectionObserver obs, boolean retried) {
            this.f = future;
            this.pool = pool;
            this.sink = sink;
            this.obs = obs;
            this.retried = retried;
        }

        @Override
        public final void dispose() {
            if (this.isDisposed()) {
                return;
            }
            this.f.removeListener(this);
            if (!this.f.isDone()) {
                this.f.cancel(true);
            }
        }

        @Override
        public Context currentContext() {
            return this.sink.currentContext();
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            this.sink.error(error);
            this.obs.onUncaughtException(connection, error);
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (newState == ConnectionObserver.State.CONFIGURED) {
                this.sink.success(connection);
            }
            this.obs.onStateChange(connection, newState);
        }

        @Override
        public boolean isDisposed() {
            return this.f.isCancelled() || this.f.isDone();
        }

        @Override
        public void run() {
            Channel c = this.f.getNow();
            this.pool.activeConnections.incrementAndGet();
            this.pool.inactiveConnections.decrementAndGet();
            ConnectionObserver current = c.attr(OWNER).getAndSet(this);
            if (current instanceof PendingConnectionObserver) {
                PendingConnectionObserver.Pending p;
                PendingConnectionObserver pending = (PendingConnectionObserver)current;
                current = null;
                this.registerClose(c, this.pool);
                while ((p = pending.pendingQueue.poll()) != null) {
                    if (p.error != null) {
                        this.onUncaughtException(p.connection, p.error);
                        continue;
                    }
                    if (p.state == null) continue;
                    this.onStateChange(p.connection, p.state);
                }
            } else if (current == null) {
                this.registerClose(c, this.pool);
            }
            if (current != null) {
                Connection conn = Connection.from(c);
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(c, "Channel acquired, now {} active connections and {} inactive connections"), this.pool.activeConnections, this.pool.inactiveConnections);
                }
                this.obs.onStateChange(conn, ConnectionObserver.State.ACQUIRED);
                PooledConnection con = conn.as(PooledConnection.class);
                if (con != null) {
                    ChannelOperations<?, ?> ops = this.pool.opsFactory.create(con, con, null);
                    if (ops != null) {
                        ops.bind();
                        this.obs.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
                        this.sink.success(ops);
                    } else {
                        this.sink.success(con);
                    }
                } else {
                    this.sink.success(conn);
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(c, "Channel connected, now {} active connections and {} inactive connections"), this.pool.activeConnections, this.pool.inactiveConnections);
            }
            if (this.pool.opsFactory == ChannelOperations.OnSetup.empty()) {
                this.sink.success(Connection.from(c));
            }
        }

        void registerClose(Channel c, Pool pool) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(c, "Registering pool release on close event for channel"));
            }
            c.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)ff -> {
                if (AttributeKey.exists("channelPool")) {
                    pool.release(c);
                }
                pool.inactiveConnections.decrementAndGet();
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(c, "Channel closed, now {} active connections and {} inactive connections"), pool.activeConnections, pool.inactiveConnections);
                }
            }));
        }

        @Override
        public final void operationComplete(Future<Channel> f) throws Exception {
            if (!f.isSuccess()) {
                if (f.isCancelled()) {
                    this.pool.inactiveConnections.decrementAndGet();
                    if (log.isDebugEnabled()) {
                        log.debug("Cancelled acquiring from pool {}", this.pool);
                    }
                    return;
                }
                Throwable cause = f.cause();
                if (cause != null) {
                    if (!(cause instanceof TimeoutException) && !(cause instanceof IllegalStateException)) {
                        this.pool.inactiveConnections.decrementAndGet();
                    }
                    this.sink.error(f.cause());
                } else {
                    this.pool.inactiveConnections.decrementAndGet();
                    this.sink.error(new IOException("Error while acquiring from " + this.pool));
                }
            } else {
                Channel c = (Channel)f.get();
                if (!c.isActive()) {
                    this.registerClose(c, this.pool);
                    if (!this.retried) {
                        if (log.isDebugEnabled()) {
                            log.debug(ReactorNetty.format(c, "Immediately aborted pooled channel, re-acquiring new channel"));
                        }
                        PooledConnectionProvider.disposableAcquire(this.sink, this.obs, this.pool, true);
                    } else {
                        Throwable cause = f.cause();
                        if (cause != null) {
                            this.sink.error(cause);
                        } else {
                            this.sink.error(new IOException("Error while acquiring from " + this.pool));
                        }
                    }
                }
                if (c.eventLoop().inEventLoop()) {
                    this.run();
                } else {
                    c.eventLoop().execute(this);
                }
            }
        }
    }

    static final class PooledConnection
    implements Connection,
    ConnectionObserver {
        final Channel channel;
        final Pool pool;
        final MonoProcessor<Void> onTerminate;

        PooledConnection(Channel channel, Pool pool) {
            this.channel = channel;
            this.pool = pool;
            this.onTerminate = MonoProcessor.create();
        }

        ConnectionObserver owner() {
            ConnectionObserver obs;
            do {
                if ((obs = this.channel.attr(OWNER).get()) != null) {
                    return obs;
                }
                obs = new PendingConnectionObserver();
            } while (!this.channel.attr(OWNER).compareAndSet(null, obs));
            return obs;
        }

        @Override
        public Mono<Void> onTerminate() {
            return this.onTerminate.or(this.onDispose());
        }

        @Override
        public Channel channel() {
            return this.channel;
        }

        @Override
        public Context currentContext() {
            return this.owner().currentContext();
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            this.owner().onUncaughtException(connection, error);
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(connection.channel(), "onStateChange({}, {})"), connection, newState);
            }
            if (newState == ConnectionObserver.State.DISCONNECTING) {
                if (!this.isPersistent() && this.channel.isActive()) {
                    this.channel.close();
                    this.owner().onStateChange(connection, ConnectionObserver.State.DISCONNECTING);
                    return;
                }
                if (!this.channel.isActive()) {
                    this.owner().onStateChange(connection, ConnectionObserver.State.DISCONNECTING);
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(connection.channel(), "Releasing channel"));
                }
                ConnectionObserver obs = this.channel.attr(OWNER).getAndSet(ConnectionObserver.emptyListener());
                this.pool.release(this.channel).addListener(f -> {
                    if (log.isDebugEnabled() && !f.isSuccess()) {
                        log.debug("Failed cleaning the channel from pool", f.cause());
                    }
                    this.onTerminate.onComplete();
                    obs.onStateChange(connection, ConnectionObserver.State.RELEASED);
                });
                return;
            }
            this.owner().onStateChange(connection, newState);
        }

        public String toString() {
            return "PooledConnection{channel=" + this.channel + '}';
        }
    }

    static final class PendingConnectionObserver
    implements ConnectionObserver {
        final Queue<Pending> pendingQueue = Queues.unbounded(4).get();

        PendingConnectionObserver() {
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            this.pendingQueue.add(new Pending(connection, error, null));
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            this.pendingQueue.add(new Pending(connection, null, newState));
        }

        static class Pending {
            final Connection connection;
            final Throwable error;
            final ConnectionObserver.State state;

            Pending(Connection connection, @Nullable Throwable error, @Nullable ConnectionObserver.State state) {
                this.connection = connection;
                this.error = error;
                this.state = state;
            }
        }
    }

    static final class Pool
    extends AtomicBoolean
    implements ChannelPoolHandler,
    ChannelPool,
    ChannelHealthChecker {
        final ChannelPool pool;
        final EventLoopGroup defaultGroup;
        final Bootstrap bootstrap;
        final ChannelOperations.OnSetup opsFactory;
        final AtomicInteger activeConnections = new AtomicInteger();
        final AtomicInteger inactiveConnections = new AtomicInteger();
        final Future<Boolean> HEALTHY;
        final Future<Boolean> UNHEALTHY;

        Pool(Bootstrap bootstrap, PoolFactory provider, ChannelOperations.OnSetup opsFactory) {
            this.bootstrap = bootstrap;
            this.opsFactory = opsFactory;
            this.pool = provider.newPool(bootstrap, this, this);
            this.defaultGroup = bootstrap.config().group();
            this.HEALTHY = this.defaultGroup.next().newSucceededFuture(true);
            this.UNHEALTHY = this.defaultGroup.next().newSucceededFuture(false);
        }

        @Override
        public Future<Boolean> isHealthy(Channel channel) {
            return channel.isActive() ? this.HEALTHY : this.UNHEALTHY;
        }

        @Override
        public Future<Channel> acquire() {
            return this.acquire(this.defaultGroup.next().newPromise());
        }

        @Override
        public Future<Channel> acquire(Promise<Channel> promise) {
            return this.pool.acquire(promise);
        }

        @Override
        public Future<Void> release(Channel channel) {
            return this.pool.release(channel);
        }

        @Override
        public Future<Void> release(Channel channel, Promise<Void> promise) {
            return this.pool.release(channel, promise);
        }

        @Override
        public void close() {
            if (this.compareAndSet(false, true)) {
                this.pool.close();
            }
        }

        @Override
        public void channelReleased(Channel ch) {
            this.activeConnections.decrementAndGet();
            this.inactiveConnections.incrementAndGet();
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(ch, "Channel cleaned, now {} active connections and {} inactive connections"), this.activeConnections, this.inactiveConnections);
            }
        }

        @Override
        public void channelAcquired(Channel ch) {
        }

        @Override
        public void channelCreated(Channel ch) {
            this.inactiveConnections.incrementAndGet();
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(ch, "Created new pooled channel, now {} active connections and {} inactive connections"), this.activeConnections, this.inactiveConnections);
            }
            PooledConnection pooledConnection = new PooledConnection(ch, this);
            pooledConnection.bind();
            Bootstrap bootstrap = this.bootstrap.clone();
            BootstrapHandlers.finalizeHandler(bootstrap, this.opsFactory, (ConnectionObserver)pooledConnection);
            ch.pipeline().addFirst(bootstrap.config().handler());
        }

        @Override
        public String toString() {
            return "{ bootstrap=" + this.bootstrap + ", activeConnections=" + this.activeConnections + ", inactiveConnections=" + this.inactiveConnections + '}';
        }
    }

    static interface PoolFactory {
        public ChannelPool newPool(Bootstrap var1, ChannelPoolHandler var2, ChannelHealthChecker var3);
    }
}

