/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.udp;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.channel.EventLoopGroup;
import io.micrometer.shaded.io.netty.channel.socket.InternetProtocolFamily;
import io.micrometer.shaded.io.netty.channel.socket.nio.NioDatagramChannel;
import io.micrometer.shaded.reactor.netty.resources.LoopResources;
import io.micrometer.shaded.reactor.netty.udp.UdpServer;
import io.micrometer.shaded.reactor.netty.udp.UdpServerOperator;
import java.util.Objects;
import javax.annotation.Nullable;

final class UdpServerRunOn
extends UdpServerOperator {
    final LoopResources loopResources;
    final boolean preferNative;
    final InternetProtocolFamily family;

    UdpServerRunOn(UdpServer server, LoopResources loopResources, boolean preferNative, @Nullable InternetProtocolFamily family) {
        super(server);
        this.loopResources = Objects.requireNonNull(loopResources, "loopResources");
        this.preferNative = preferNative;
        this.family = family;
    }

    @Override
    protected Bootstrap configure() {
        Bootstrap b = this.source.configure();
        boolean useNative = this.family == null && this.preferNative;
        EventLoopGroup elg = this.loopResources.onClient(useNative);
        if (useNative) {
            b.channel(this.loopResources.onDatagramChannel(elg));
        } else {
            b.channelFactory(() -> new NioDatagramChannel(this.family));
        }
        return (Bootstrap)b.group(elg);
    }
}

