/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.transport;

import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelOption;
import io.micrometer.shaded.io.netty.channel.EventLoopGroup;
import io.micrometer.shaded.io.netty.channel.group.ChannelGroup;
import io.micrometer.shaded.io.netty.channel.socket.SocketChannel;
import io.micrometer.shaded.io.netty.channel.unix.DomainSocketChannel;
import io.micrometer.shaded.io.netty.resolver.AddressResolverGroup;
import io.micrometer.shaded.io.netty.resolver.dns.DnsAddressResolverGroup;
import io.micrometer.shaded.reactor.netty.ChannelPipelineConfigurer;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.internal.util.MapUtils;
import io.micrometer.shaded.reactor.netty.resources.ConnectionProvider;
import io.micrometer.shaded.reactor.netty.resources.LoopResources;
import io.micrometer.shaded.reactor.netty.transport.AddressResolverGroupMetrics;
import io.micrometer.shaded.reactor.netty.transport.NameResolverProvider;
import io.micrometer.shaded.reactor.netty.transport.ProxyProvider;
import io.micrometer.shaded.reactor.netty.transport.TransportConfig;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class ClientTransportConfig<CONF extends TransportConfig>
extends TransportConfig {
    final ConnectionProvider connectionProvider;
    Consumer<? super CONF> doOnConnect;
    Consumer<? super Connection> doOnConnected;
    Consumer<? super Connection> doOnDisconnected;
    Consumer<? super Connection> doOnResolve;
    BiConsumer<? super Connection, ? super SocketAddress> doAfterResolve;
    BiConsumer<? super Connection, ? super Throwable> doOnResolveError;
    NameResolverProvider nameResolverProvider;
    ProxyProvider proxyProvider;
    Supplier<? extends SocketAddress> remoteAddress;
    AddressResolverGroup<?> resolver;
    static final ConcurrentMap<Integer, DnsAddressResolverGroup> RESOLVERS_CACHE = new ConcurrentHashMap<Integer, DnsAddressResolverGroup>();
    static final NameResolverProvider DEFAULT_NAME_RESOLVER_PROVIDER = NameResolverProvider.builder().build();

    @Override
    public int channelHash() {
        return Objects.hash(super.channelHash(), this.proxyProvider, this.resolver);
    }

    public ConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    @Nullable
    public final Consumer<? super CONF> doOnConnect() {
        return this.doOnConnect;
    }

    @Nullable
    public final Consumer<? super Connection> doOnConnected() {
        return this.doOnConnected;
    }

    @Nullable
    public final Consumer<? super Connection> doOnDisconnected() {
        return this.doOnDisconnected;
    }

    public final boolean hasProxy() {
        return this.proxyProvider != null;
    }

    @Nullable
    public NameResolverProvider getNameResolverProvider() {
        return this.nameResolverProvider;
    }

    @Nullable
    public final ProxyProvider proxyProvider() {
        return this.proxyProvider;
    }

    public final Supplier<? extends SocketAddress> remoteAddress() {
        return this.remoteAddress;
    }

    @Nullable
    public final AddressResolverGroup<?> resolver() {
        return this.resolver;
    }

    protected ClientTransportConfig(ConnectionProvider connectionProvider, Map<ChannelOption<?>, ?> options, Supplier<? extends SocketAddress> remoteAddress) {
        super(options);
        this.connectionProvider = Objects.requireNonNull(connectionProvider, "connectionProvider");
        this.remoteAddress = Objects.requireNonNull(remoteAddress, "remoteAddress");
    }

    protected ClientTransportConfig(ClientTransportConfig<CONF> parent) {
        super(parent);
        this.connectionProvider = parent.connectionProvider;
        this.doOnConnect = parent.doOnConnect;
        this.doOnConnected = parent.doOnConnected;
        this.doOnDisconnected = parent.doOnDisconnected;
        this.doOnResolve = parent.doOnResolve;
        this.doAfterResolve = parent.doAfterResolve;
        this.doOnResolveError = parent.doOnResolveError;
        this.nameResolverProvider = parent.nameResolverProvider;
        this.proxyProvider = parent.proxyProvider;
        this.remoteAddress = parent.remoteAddress;
        this.resolver = parent.resolver;
    }

    @Override
    protected Class<? extends Channel> channelType(boolean isDomainSocket) {
        return isDomainSocket ? DomainSocketChannel.class : SocketChannel.class;
    }

    protected abstract AddressResolverGroup<?> defaultAddressResolverGroup();

    @Override
    protected ConnectionObserver defaultConnectionObserver() {
        if (this.channelGroup() == null && this.doOnConnected() == null && this.doOnDisconnected() == null) {
            return ConnectionObserver.emptyListener();
        }
        return new ClientTransportDoOn(this.channelGroup(), this.doOnConnected(), this.doOnDisconnected());
    }

    @Override
    protected ChannelPipelineConfigurer defaultOnChannelInit() {
        if (this.proxyProvider != null) {
            return new ClientTransportChannelInitializer(this.proxyProvider);
        }
        return ChannelPipelineConfigurer.emptyConfigurer();
    }

    @Override
    protected EventLoopGroup eventLoopGroup() {
        return this.loopResources().onClient(this.isPreferNative());
    }

    protected void proxyProvider(@Nullable ProxyProvider proxyProvider) {
        this.proxyProvider = proxyProvider;
    }

    protected AddressResolverGroup<?> resolverInternal() {
        AddressResolverGroup<?> resolverGroup;
        AddressResolverGroup<?> addressResolverGroup = resolverGroup = this.resolver != null ? this.resolver : this.defaultAddressResolverGroup();
        if (this.metricsRecorder != null) {
            return AddressResolverGroupMetrics.getOrCreate(resolverGroup, this.metricsRecorder);
        }
        return resolverGroup;
    }

    static DnsAddressResolverGroup getOrCreateResolver(NameResolverProvider nameResolverProvider, LoopResources loopResources, boolean preferNative) {
        return MapUtils.computeIfAbsent(RESOLVERS_CACHE, Objects.hash(nameResolverProvider, loopResources, preferNative), key -> nameResolverProvider.newNameResolverGroup(loopResources, preferNative));
    }

    static final class ClientTransportDoOn
    implements ConnectionObserver {
        final ChannelGroup channelGroup;
        final Consumer<? super Connection> doOnConnected;
        final Consumer<? super Connection> doOnDisconnected;

        ClientTransportDoOn(@Nullable ChannelGroup channelGroup, @Nullable Consumer<? super Connection> doOnConnected, @Nullable Consumer<? super Connection> doOnDisconnected) {
            this.channelGroup = channelGroup;
            this.doOnConnected = doOnConnected;
            this.doOnDisconnected = doOnDisconnected;
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (this.channelGroup != null && newState == ConnectionObserver.State.CONNECTED) {
                this.channelGroup.add(connection.channel());
                return;
            }
            if (this.doOnConnected != null && newState == ConnectionObserver.State.CONFIGURED) {
                this.doOnConnected.accept(connection);
                return;
            }
            if (this.doOnDisconnected != null) {
                if (newState == ConnectionObserver.State.DISCONNECTING) {
                    connection.onDispose(() -> this.doOnDisconnected.accept(connection));
                } else if (newState == ConnectionObserver.State.RELEASED) {
                    this.doOnDisconnected.accept(connection);
                }
            }
        }
    }

    static final class ClientTransportChannelInitializer
    implements ChannelPipelineConfigurer {
        final ProxyProvider proxyProvider;

        ClientTransportChannelInitializer(ProxyProvider proxyProvider) {
            this.proxyProvider = proxyProvider;
        }

        @Override
        public void onChannelInit(ConnectionObserver connectionObserver, Channel channel, SocketAddress remoteAddress) {
            if (this.proxyProvider.shouldProxy(remoteAddress)) {
                this.proxyProvider.addProxyHandler(channel);
            }
        }
    }
}

