/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.channel;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.ByteBufHolder;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.FileRegion;
import io.micrometer.shaded.io.netty.util.ReferenceCountUtil;
import io.micrometer.shaded.io.netty.util.ReferenceCounted;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;

abstract class MonoSend<I, O>
extends Mono<Void> {
    final ChannelHandlerContext ctx;
    final Function<? super I, ? extends O> transformer;
    final Consumer<? super I> sourceCleanup;
    final ToIntFunction<? super O> sizeOf;
    static final int MAX_SIZE = 128;
    static final int REFILL_SIZE = 64;
    static final Function<ByteBuf, ByteBuf> FUNCTION_BB_IDENTITY = Function.identity();
    static final Function<Object, Object> FUNCTION_IDENTITY = Function.identity();
    static final Consumer<ByteBuf> CONSUMER_BB_NOCHECK_CLEANUP = ReferenceCounted::release;
    static final Consumer<Object> CONSUMER_NOCHECK_CLEANUP = ReferenceCountUtil::release;
    static final ToIntFunction<ByteBuf> SIZE_OF_BB = ByteBuf::readableBytes;
    static final ToIntFunction<Object> SIZE_OF = msg -> {
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof FileRegion) {
            return 0;
        }
        return -1;
    };

    MonoSend(Channel channel, Function<? super I, ? extends O> transformer, Consumer<? super I> sourceCleanup, ToIntFunction<? super O> sizeOf) {
        this.transformer = Objects.requireNonNull(transformer, "source transformer cannot be null");
        this.sourceCleanup = Objects.requireNonNull(sourceCleanup, "source cleanup handler cannot be null");
        this.sizeOf = Objects.requireNonNull(sizeOf, "message size mapper cannot be null");
        this.ctx = Objects.requireNonNull(channel.pipeline().lastContext(), "reactiveBridge is not installed");
    }

    static <O> ToIntFunction<O> defaultSizeOf() {
        return SIZE_OF;
    }
}

