/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.channel;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.ByteBufHolder;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelFuture;
import io.micrometer.shaded.io.netty.channel.ChannelFutureListener;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.channel.DefaultChannelPromise;
import io.micrometer.shaded.io.netty.channel.EventLoop;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.MonoSend;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.concurrent.Queues;
import io.micrometer.shaded.reactor.util.context.Context;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;

final class MonoSendMany<I, O>
extends MonoSend<I, O>
implements Scannable {
    final Publisher<? extends I> source;
    final boolean flushOnEach;
    static final Logger log = Loggers.getLogger(MonoSendMany.class);

    static MonoSendMany<ByteBuf, ByteBuf> byteBufSource(Publisher<? extends ByteBuf> source, Channel channel, boolean flushOption) {
        return new MonoSendMany<ByteBuf, ByteBuf>(source, channel, flushOption, FUNCTION_BB_IDENTITY, CONSUMER_BB_NOCHECK_CLEANUP, SIZE_OF_BB);
    }

    static MonoSendMany<?, ?> objectSource(Publisher<?> source, Channel channel, boolean flushOnEach) {
        return new MonoSendMany(source, channel, flushOnEach, FUNCTION_IDENTITY, CONSUMER_NOCHECK_CLEANUP, SIZE_OF);
    }

    MonoSendMany(Publisher<? extends I> source, Channel channel, boolean flushOnEach, Function<? super I, ? extends O> transformer, Consumer<? super I> sourceCleanup, ToIntFunction<O> sizeOf) {
        super(channel, transformer, sourceCleanup, sizeOf);
        this.source = Objects.requireNonNull(source, "source publisher cannot be null");
        this.flushOnEach = flushOnEach;
    }

    @Override
    public void subscribe(CoreSubscriber<? super Void> destination) {
        this.source.subscribe(new SendManyInner(this, destination));
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return 128;
        }
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        return null;
    }

    static final class SendManyInner<I, O>
    implements CoreSubscriber<I>,
    Subscription,
    Fuseable,
    ChannelFutureListener,
    Runnable,
    Scannable,
    ChannelPromise {
        final ChannelHandlerContext ctx;
        final EventLoop eventLoop;
        final MonoSendMany<I, O> parent;
        final CoreSubscriber<? super Void> actual;
        final Runnable asyncFlush;
        volatile Subscription s;
        volatile int wip;
        Queue<I> queue;
        boolean done;
        int pending;
        int requested;
        int sourceMode;
        boolean needFlush;
        int nextRequest;
        static final AtomicIntegerFieldUpdater<SendManyInner> WIP = AtomicIntegerFieldUpdater.newUpdater(SendManyInner.class, "wip");
        static final AtomicReferenceFieldUpdater<SendManyInner, Subscription> SUBSCRIPTION = AtomicReferenceFieldUpdater.newUpdater(SendManyInner.class, Subscription.class, "s");

        SendManyInner(MonoSendMany<I, O> parent, CoreSubscriber<? super Void> actual) {
            this.parent = parent;
            this.actual = actual;
            this.requested = 128;
            this.ctx = parent.ctx;
            this.eventLoop = this.ctx.channel().eventLoop();
            this.asyncFlush = new AsyncFlush();
            this.ctx.channel().closeFuture().addListener(this);
        }

        @Override
        public Context currentContext() {
            return this.actual.currentContext();
        }

        @Override
        public void cancel() {
            if (Operators.terminate(SUBSCRIPTION, this)) {
                return;
            }
            if (WIP.getAndIncrement(this) == 0) {
                this.cleanup();
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.ctx.channel().closeFuture().removeListener(this);
            this.trySchedule(null);
        }

        @Override
        public void onError(Throwable t) {
            if (SUBSCRIPTION.getAndSet(this, Operators.cancelledSubscription()) == Operators.cancelledSubscription()) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            if (WIP.getAndIncrement(this) == 0) {
                this.cleanup();
            }
            if (t instanceof ClosedChannelException) {
                t = ReactorNetty.wrapException(t);
            }
            this.actual.onError(t);
        }

        @Override
        public void onNext(I t) {
            if (this.sourceMode == 2) {
                this.trySchedule(null);
                return;
            }
            if (this.done) {
                this.parent.sourceCleanup.accept(t);
                Operators.onDiscard(t, this.actual.currentContext());
                return;
            }
            if (!this.queue.offer(t)) {
                this.onError(Operators.onOperatorError(this.s, Exceptions.failWithOverflow("Queue is full: Reactive Streams source doesn't respect backpressure"), t, this.actual.currentContext()));
                return;
            }
            this.trySchedule(t);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(SUBSCRIPTION, this, s)) {
                if (s instanceof Fuseable.QueueSubscription) {
                    Fuseable.QueueSubscription f = (Fuseable.QueueSubscription)s;
                    int m = f.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = 1;
                        this.queue = f;
                        this.done = true;
                        this.actual.onSubscribe(this);
                        this.trySchedule(null);
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = 2;
                        this.queue = f;
                        this.actual.onSubscribe(this);
                        s.request(128L);
                        return;
                    }
                }
                this.queue = Queues.get(128).get();
                this.actual.onSubscribe(this);
                s.request(128L);
            }
        }

        @Override
        public void request(long n) {
        }

        @Override
        public void operationComplete(ChannelFuture future) {
            if (Operators.terminate(SUBSCRIPTION, this)) {
                if (WIP.getAndIncrement(this) == 0) {
                    this.cleanup();
                }
                this.actual.onComplete();
            }
        }

        @Override
        public void run() {
            Queue<I> queue = this.queue;
            try {
                int missed = 1;
                do {
                    I sourceMessage;
                    int r = this.requested;
                    while (Integer.MAX_VALUE != r && r-- > 0 && (sourceMessage = queue.poll()) != null) {
                        if (this.s == Operators.cancelledSubscription()) {
                            this.parent.sourceCleanup.accept(sourceMessage);
                            Operators.onDiscard(sourceMessage, this.actual.currentContext());
                            this.cleanup();
                            return;
                        }
                        Object encodedMessage = this.parent.transformer.apply(sourceMessage);
                        int readableBytes = this.parent.sizeOf.applyAsInt(encodedMessage);
                        if (readableBytes == 0 && !(encodedMessage instanceof ByteBufHolder)) {
                            ++r;
                            continue;
                        }
                        ++this.pending;
                        this.ctx.write(encodedMessage, this);
                        if (this.parent.flushOnEach || !this.ctx.channel().isWritable() || (long)readableBytes > this.ctx.channel().bytesBeforeUnwritable()) {
                            this.needFlush = false;
                            this.ctx.flush();
                            continue;
                        }
                        this.needFlush = true;
                    }
                    if (this.needFlush && this.pending != 0) {
                        this.needFlush = false;
                        this.eventLoop.execute(this.asyncFlush);
                    }
                    if (Operators.cancelledSubscription() == this.s) {
                        this.cleanup();
                        return;
                    }
                    if (this.tryComplete()) {
                        return;
                    }
                    int nextRequest = this.nextRequest;
                    if (this.done || nextRequest == 0) continue;
                    this.nextRequest = 0;
                    this.s.request(nextRequest);
                } while ((missed = WIP.addAndGet(this, -missed)) != 0);
            }
            catch (Throwable t) {
                this.cleanup();
                if (Operators.terminate(SUBSCRIPTION, this)) {
                    this.actual.onError(t);
                }
                Operators.onErrorDropped(t, this.actual.currentContext());
            }
        }

        void cleanup() {
            this.ctx.channel().closeFuture().removeListener(this);
            Context context = this.actual.currentContext();
            Queue<I> queue = this.queue;
            if (queue == null) {
                return;
            }
            while (!queue.isEmpty()) {
                I sourceMessage = queue.poll();
                if (sourceMessage == null) continue;
                this.parent.sourceCleanup.accept(sourceMessage);
                Operators.onDiscard(sourceMessage, context);
            }
        }

        boolean tryComplete() {
            if (this.pending == 0 && this.done && this.queue.isEmpty() && SUBSCRIPTION.getAndSet(this, Operators.cancelledSubscription()) != Operators.cancelledSubscription()) {
                this.actual.onComplete();
                return true;
            }
            return false;
        }

        void trySchedule(@Nullable Object data) {
            block4: {
                if (WIP.getAndIncrement(this) == 0) {
                    try {
                        if (this.eventLoop.inEventLoop()) {
                            this.run();
                            return;
                        }
                        this.eventLoop.execute(this);
                    }
                    catch (Throwable t) {
                        if (!Operators.terminate(SUBSCRIPTION, this)) break block4;
                        this.cleanup();
                        this.actual.onError(Operators.onRejectedExecution(t, null, null, data, this.actual.currentContext()));
                    }
                }
            }
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.actual;
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requested;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return Operators.cancelledSubscription() == this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.queue != null ? this.queue.size() : 0;
            }
            if (key == Scannable.Attr.PREFETCH) {
                return 128;
            }
            return null;
        }

        @Override
        public Channel channel() {
            return this.ctx.channel();
        }

        @Override
        public ChannelPromise setSuccess(Void result) {
            this.trySuccess(null);
            return this;
        }

        @Override
        public ChannelPromise setSuccess() {
            this.trySuccess(null);
            return this;
        }

        @Override
        public boolean trySuccess() {
            this.trySuccess(null);
            return true;
        }

        @Override
        public ChannelPromise setFailure(Throwable cause) {
            if (this.tryFailure(cause)) {
                return this;
            }
            Operators.onErrorDropped(cause, this.actual.currentContext());
            return this;
        }

        @Override
        public ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> listener) {
            return this;
        }

        @Override
        public ChannelPromise removeListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
            return this;
        }

        @Override
        public ChannelPromise sync() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise syncUninterruptibly() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise await() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise awaitUninterruptibly() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelPromise unvoid() {
            return new DefaultChannelPromise(this.ctx.channel()).addListener((GenericFutureListener)this);
        }

        @Override
        public boolean isVoid() {
            return false;
        }

        @Override
        public boolean trySuccess(Void result) {
            --this.requested;
            --this.pending;
            if (this.tryComplete()) {
                return true;
            }
            if (this.requested <= 64) {
                int u = 128 - this.requested;
                this.requested += u;
                this.nextRequest += u;
                this.trySchedule(null);
            }
            return true;
        }

        @Override
        public boolean tryFailure(Throwable cause) {
            if (Operators.terminate(SUBSCRIPTION, this)) {
                if (WIP.getAndIncrement(this) == 0) {
                    this.cleanup();
                }
                this.actual.onError(cause);
            }
            return true;
        }

        @Override
        public boolean setUncancellable() {
            return true;
        }

        @Override
        public boolean isSuccess() {
            return this.done && this.queue.isEmpty();
        }

        @Override
        public boolean isCancellable() {
            return false;
        }

        @Override
        @Nullable
        public Throwable cause() {
            return null;
        }

        @Override
        public boolean await(long timeout, TimeUnit unit) {
            return false;
        }

        @Override
        public boolean await(long timeoutMillis) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean awaitUninterruptibly(long timeoutMillis) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Void getNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public Void get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Void get(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        final class AsyncFlush
        implements Runnable {
            AsyncFlush() {
            }

            @Override
            public void run() {
                if (SendManyInner.this.pending != 0) {
                    SendManyInner.this.ctx.flush();
                }
            }
        }
    }
}

