/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.server;

import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2DataFrame;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2Frame;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2Headers;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2HeadersFrame;
import io.micrometer.shaded.io.netty.util.ReferenceCountUtil;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.http.server.ConnectionInfo;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerOperations;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerState;

public class HttpToH2Operations
extends HttpServerOperations {
    final Http2Headers http2Headers;

    HttpToH2Operations(Connection c, ConnectionObserver listener, HttpRequest request, Http2Headers headers, ConnectionInfo connectionInfo, ServerCookieEncoder encoder, ServerCookieDecoder decoder) {
        super(c, listener, null, request, connectionInfo, encoder, decoder);
        this.http2Headers = headers;
    }

    @Override
    protected void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Http2Frame) {
            if (msg instanceof Http2DataFrame) {
                Http2DataFrame data = (Http2DataFrame)msg;
                super.onInboundNext(ctx, data);
                if (data.isEndStream()) {
                    this.onInboundComplete();
                }
                return;
            }
            if (msg instanceof Http2HeadersFrame) {
                try {
                    this.listener().onStateChange(this, HttpServerState.REQUEST_RECEIVED);
                }
                catch (Exception e) {
                    this.onInboundError(e);
                    ReferenceCountUtil.release(msg);
                    return;
                }
                if (((Http2HeadersFrame)msg).isEndStream()) {
                    super.onInboundNext(ctx, msg);
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Unused H2 frame " + msg.toString()));
            }
            return;
        }
        super.onInboundNext(ctx, msg);
    }
}

