/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.publisher.FluxFromMonoOperator;
import io.micrometer.shaded.reactor.core.publisher.FluxRepeatPredicate;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import java.util.Objects;
import java.util.function.BooleanSupplier;

final class MonoRepeatPredicate<T>
extends FluxFromMonoOperator<T, T> {
    final BooleanSupplier predicate;

    MonoRepeatPredicate(Mono<? extends T> source, BooleanSupplier predicate) {
        super(source);
        this.predicate = Objects.requireNonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        FluxRepeatPredicate.RepeatPredicateSubscriber<T> parent = new FluxRepeatPredicate.RepeatPredicateSubscriber<T>(this.source, actual, this.predicate);
        actual.onSubscribe(parent);
        if (!parent.isCancelled()) {
            parent.resubscribe();
        }
    }
}

