/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.client;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.ByteBufAllocator;
import io.micrometer.shaded.io.netty.channel.ChannelOption;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.ByteBufFlux;
import io.micrometer.shaded.reactor.netty.ByteBufMono;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.NettyOutbound;
import io.micrometer.shaded.reactor.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.netty.http.client.HttpClient;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientConfiguration;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientForm;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientOperations;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientRequest;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientResponse;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

final class HttpClientFinalizer
extends HttpClient
implements HttpClient.RequestSender {
    final TcpClient cachedConfiguration;
    static final Function<HttpClientOperations, HttpClientResponse> RESPONSE_ONLY = ops -> {
        HttpClientFinalizer.discard(ops);
        return ops;
    };
    static final Function<ChannelOperations<?, ?>, Publisher<ByteBuf>> contentReceiver = ChannelOperations::receive;

    HttpClientFinalizer(TcpClient parent) {
        this.cachedConfiguration = parent;
    }

    @Override
    public HttpClient.RequestSender uri(String uri) {
        return new HttpClientFinalizer(this.cachedConfiguration.bootstrap(b -> HttpClientConfiguration.uri(b, uri)));
    }

    @Override
    public HttpClient.RequestSender uri(Mono<String> uri) {
        return new HttpClientFinalizer(this.cachedConfiguration.bootstrap(b -> HttpClientConfiguration.deferredConf(b, conf -> uri.map(conf::uri))));
    }

    Mono<HttpClientOperations> connect() {
        return this.cachedConfiguration.connect();
    }

    @Override
    public Mono<HttpClientResponse> response() {
        return this.connect().map(RESPONSE_ONLY);
    }

    @Override
    public <V> Flux<V> response(BiFunction<? super HttpClientResponse, ? super ByteBufFlux, ? extends Publisher<V>> receiver) {
        return this.connect().flatMapMany(resp -> Flux.from((Publisher)receiver.apply((HttpClientResponse)resp, resp.receive())).doFinally(s -> HttpClientFinalizer.discard(resp)));
    }

    @Override
    public <V> Flux<V> responseConnection(BiFunction<? super HttpClientResponse, ? super Connection, ? extends Publisher<V>> receiver) {
        return this.connect().flatMapMany(resp -> Flux.from((Publisher)receiver.apply((HttpClientResponse)resp, (Connection)resp)));
    }

    @Override
    public ByteBufFlux responseContent() {
        return HttpClientFinalizer.content(this.cachedConfiguration, contentReceiver);
    }

    @Override
    public <V> Mono<V> responseSingle(BiFunction<? super HttpClientResponse, ? super ByteBufMono, ? extends Mono<V>> receiver) {
        return this.connect().flatMap(resp -> ((Mono)receiver.apply((HttpClientResponse)resp, resp.receive().aggregate())).doFinally(s -> HttpClientFinalizer.discard(resp)));
    }

    public HttpClientFinalizer send(Publisher<? extends ByteBuf> requestBody) {
        Objects.requireNonNull(requestBody, "requestBody");
        return this.send((T req, U out) -> out.sendObject(requestBody));
    }

    public HttpClientFinalizer send(BiFunction<? super HttpClientRequest, ? super NettyOutbound, ? extends Publisher<Void>> sender) {
        Objects.requireNonNull(sender, "requestBody");
        return new HttpClientFinalizer(this.cachedConfiguration.bootstrap(b -> HttpClientConfiguration.body(b, sender)));
    }

    public HttpClientFinalizer sendForm(BiConsumer<? super HttpClientRequest, HttpClientForm> formCallback, @Nullable Consumer<Flux<Long>> progress) {
        Objects.requireNonNull(formCallback, "formCallback");
        return this.send((T req, U out) -> {
            HttpClientOperations ops = (HttpClientOperations)out;
            return new HttpClientOperations.SendForm(ops, formCallback, progress);
        });
    }

    static ByteBufFlux content(TcpClient cachedConfiguration, Function<ChannelOperations<?, ?>, Publisher<ByteBuf>> contentReceiver) {
        Bootstrap b;
        try {
            b = cachedConfiguration.configure();
        }
        catch (Throwable t) {
            Exceptions.throwIfJvmFatal(t);
            return ByteBufFlux.fromInbound(Mono.error(t));
        }
        ByteBufAllocator alloc = (ByteBufAllocator)b.config().options().getOrDefault(ChannelOption.ALLOCATOR, ByteBufAllocator.DEFAULT);
        Mono<? extends Connection> connector = cachedConfiguration.connect(b);
        return ByteBufFlux.fromInbound(connector.flatMapMany(contentReceiver), alloc);
    }

    static void discard(HttpClientOperations c) {
        if (!c.isInboundDisposed()) {
            c.discard();
        }
    }
}

