/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty;

import io.micrometer.shaded.io.netty.bootstrap.AbstractBootstrap;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;

public class ChannelBindException
extends RuntimeException {
    final String localHost;
    final int localPort;

    @Deprecated
    public static ChannelBindException fail(AbstractBootstrap<?, ?> bootstrap, @Nullable Throwable cause) {
        Objects.requireNonNull(bootstrap, "bootstrap");
        if (cause instanceof BindException || cause instanceof IOException && cause.getMessage() != null && cause.getMessage().contains("Address already in use")) {
            cause = null;
        }
        if (!(bootstrap.config().localAddress() instanceof InetSocketAddress)) {
            return new ChannelBindException(bootstrap.config().localAddress().toString(), -1, cause);
        }
        InetSocketAddress address = (InetSocketAddress)bootstrap.config().localAddress();
        return new ChannelBindException(address.getHostString(), address.getPort(), cause);
    }

    public static ChannelBindException fail(SocketAddress localAddress, @Nullable Throwable cause) {
        Objects.requireNonNull(localAddress, "localAddress");
        if (cause instanceof BindException || cause instanceof IOException && cause.getMessage() != null && cause.getMessage().contains("Address already in use")) {
            cause = null;
        }
        if (!(localAddress instanceof InetSocketAddress)) {
            return new ChannelBindException(localAddress.toString(), -1, cause);
        }
        InetSocketAddress address = (InetSocketAddress)localAddress;
        return new ChannelBindException(address.getHostString(), address.getPort(), cause);
    }

    protected ChannelBindException(String localHost, int localPort, @Nullable Throwable cause) {
        super("Failed to bind on [" + localHost + ":" + localPort + "]", cause);
        this.localHost = localHost;
        this.localPort = localPort;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    public String localHost() {
        return this.localHost;
    }

    public int localPort() {
        return this.localPort;
    }
}

