/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.client;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.handler.codec.http.EmptyHttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpMethod;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpVersion;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.Cookie;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.channel.BootstrapHandlers;
import io.micrometer.shaded.reactor.netty.http.Cookies;
import io.micrometer.shaded.reactor.netty.http.HttpOperations;
import io.micrometer.shaded.reactor.netty.http.client.HttpClient;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientConfiguration;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientOperations;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientOperator;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientRequest;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientResponse;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientState;
import io.micrometer.shaded.reactor.netty.http.client.PrematureCloseException;
import io.micrometer.shaded.reactor.netty.http.client.RedirectClientException;
import io.micrometer.shaded.reactor.netty.tcp.ProxyProvider;
import io.micrometer.shaded.reactor.netty.tcp.SslProvider;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import io.micrometer.shaded.reactor.util.context.Context;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

final class HttpClientDoOnError
extends HttpClientOperator {
    final BiConsumer<? super HttpClientRequest, ? super Throwable> onRequestError;
    final BiConsumer<? super HttpClientResponse, ? super Throwable> onResponseError;

    HttpClientDoOnError(HttpClient client, @Nullable BiConsumer<? super HttpClientRequest, ? super Throwable> onRequestError, @Nullable BiConsumer<? super HttpClientResponse, ? super Throwable> onResponseError) {
        super(client);
        this.onRequestError = onRequestError;
        this.onResponseError = onResponseError;
    }

    @Override
    protected TcpClient tcpConfiguration() {
        return new OnErrorTcpClient(this.source.tcpConfiguration(), this.onRequestError, this.onResponseError);
    }

    static final class OnErrorTcpClient
    extends TcpClient
    implements ConnectionObserver {
        final TcpClient sourceTcp;
        final BiConsumer<? super HttpClientRequest, ? super Throwable> onRequestError;
        final BiConsumer<? super HttpClientResponse, ? super Throwable> onResponseError;

        OnErrorTcpClient(TcpClient sourceTcp, @Nullable BiConsumer<? super HttpClientRequest, ? super Throwable> onRequestError, @Nullable BiConsumer<? super HttpClientResponse, ? super Throwable> onResponseError) {
            this.onRequestError = onRequestError;
            this.onResponseError = onResponseError;
            this.sourceTcp = sourceTcp;
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (this.onResponseError != null && newState == HttpClientState.RESPONSE_INCOMPLETE) {
                HttpClientOperations ops = connection.as(HttpClientOperations.class);
                if (ops == null) {
                    return;
                }
                if (ops.responseState != null) {
                    this.onResponseError.accept(ops, new PrematureCloseException("Connection prematurely closed DURING response"));
                }
            }
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            HttpClientOperations ops = connection.as(HttpClientOperations.class);
            if (ops == null) {
                return;
            }
            if (this.onRequestError != null && ops.retrying && ops.responseState == null) {
                this.onRequestError.accept(connection.as(HttpClientOperations.class), error);
                return;
            }
            if (this.onResponseError != null && ops.responseState != null && !(error instanceof RedirectClientException)) {
                this.onResponseError.accept(connection.as(HttpClientOperations.class), error);
            }
        }

        @Override
        public Mono<? extends Connection> connect(Bootstrap b) {
            if (this.onRequestError != null) {
                HttpClientConfiguration c = HttpClientConfiguration.get(b);
                return this.sourceTcp.connect(b).onErrorResume(error -> Mono.subscriberContext().doOnNext(ctx -> this.onRequestError.accept(new PreparingHttpClientRequest((Context)ctx, c), (Throwable)error)).then(Mono.error(error)));
            }
            return this.sourceTcp.connect(b);
        }

        @Override
        public Bootstrap configure() {
            Bootstrap bootstrap = this.sourceTcp.configure();
            ConnectionObserver observer = BootstrapHandlers.connectionObserver(bootstrap);
            BootstrapHandlers.connectionObserver(bootstrap, observer.then(this));
            return bootstrap;
        }

        @Override
        @Nullable
        public ProxyProvider proxyProvider() {
            return this.sourceTcp.proxyProvider();
        }

        @Override
        @Nullable
        public SslProvider sslProvider() {
            return this.sourceTcp.sslProvider();
        }
    }

    static final class PreparingHttpClientRequest
    implements HttpClientRequest {
        final HttpHeaders headers;
        final HttpMethod method;
        final String uri;
        final String path;
        final Context context;
        final ClientCookieDecoder cookieDecoder;
        final boolean isWebsocket;
        static final String[] EMPTY = new String[0];

        PreparingHttpClientRequest(Context context, HttpClientConfiguration c) {
            this.context = context;
            this.headers = c.headers;
            this.cookieDecoder = c.cookieDecoder;
            this.uri = c.uri;
            this.path = HttpOperations.resolvePath(this.uri);
            this.method = c.method;
            this.isWebsocket = c.websocketClientSpec != null;
        }

        @Override
        public HttpClientRequest addCookie(Cookie cookie) {
            throw new UnsupportedOperationException("Should not add Cookie");
        }

        @Override
        public HttpClientRequest addHeader(CharSequence name, CharSequence value) {
            throw new UnsupportedOperationException("Should not add Header");
        }

        @Override
        public HttpClientRequest header(CharSequence name, CharSequence value) {
            throw new UnsupportedOperationException("Should not add Header");
        }

        @Override
        public HttpClientRequest headers(HttpHeaders headers) {
            throw new UnsupportedOperationException("Should not add Header");
        }

        @Override
        public Context currentContext() {
            return this.context;
        }

        @Override
        public boolean isFollowRedirect() {
            return true;
        }

        @Override
        public String[] redirectedFrom() {
            return EMPTY;
        }

        @Override
        public String resourceUrl() {
            return null;
        }

        @Override
        public HttpHeaders requestHeaders() {
            return this.headers != null ? this.headers : EmptyHttpHeaders.INSTANCE;
        }

        @Override
        public Map<CharSequence, Set<Cookie>> cookies() {
            if (this.headers == null) {
                return Collections.emptyMap();
            }
            return Cookies.newClientResponseHolder(this.headers, this.cookieDecoder).getCachedCookies();
        }

        @Override
        public boolean isKeepAlive() {
            if (this.headers == null) {
                return true;
            }
            return HttpHeaderValues.CLOSE.contentEqualsIgnoreCase(this.headers.get(HttpHeaderNames.CONNECTION));
        }

        @Override
        public boolean isWebsocket() {
            return this.isWebsocket;
        }

        @Override
        public HttpMethod method() {
            return this.method;
        }

        @Override
        public String uri() {
            return this.uri;
        }

        @Override
        public String fullPath() {
            return this.path;
        }

        @Override
        public HttpVersion version() {
            return HttpVersion.HTTP_1_1;
        }
    }
}

