/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.client;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.http.client.HttpClient;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientConfiguration;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientOperator;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

final class HttpClientHeadersWhen
extends HttpClientOperator
implements Function<Bootstrap, Bootstrap> {
    final Function<? super HttpHeaders, Mono<? extends HttpHeaders>> headers;

    HttpClientHeadersWhen(HttpClient client, Function<? super HttpHeaders, Mono<? extends HttpHeaders>> headers) {
        super(client);
        this.headers = Objects.requireNonNull(headers, "headers");
    }

    @Override
    protected TcpClient tcpConfiguration() {
        return this.source.tcpConfiguration().bootstrap(this);
    }

    @Override
    public Bootstrap apply(Bootstrap bootstrap) {
        HttpClientConfiguration.deferredConf(bootstrap, conf -> this.headers.apply(HttpClientHeadersWhen.getOrCreate(conf.headers)).map(conf::headers));
        return bootstrap;
    }

    static HttpHeaders getOrCreate(@Nullable HttpHeaders h) {
        if (h == null) {
            return new DefaultHttpHeaders();
        }
        return h;
    }
}

