/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.server;

import io.micrometer.shaded.reactor.netty.http.HttpDecoderSpec;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerConfiguration;
import io.micrometer.shaded.reactor.netty.tcp.TcpServer;
import java.util.function.Function;

public final class HttpRequestDecoderSpec
extends HttpDecoderSpec<HttpRequestDecoderSpec> {
    public static final int DEFAULT_H2C_MAX_CONTENT_LENGTH = 0;
    int h2cMaxContentLength = 0;

    @Override
    public HttpRequestDecoderSpec get() {
        return this;
    }

    public HttpRequestDecoderSpec h2cMaxContentLength(int h2cMaxContentLength) {
        this.h2cMaxContentLength = h2cMaxContentLength;
        return this;
    }

    Function<TcpServer, TcpServer> build() {
        HttpRequestDecoderSpec decoder = new HttpRequestDecoderSpec();
        decoder.initialBufferSize = this.initialBufferSize;
        decoder.maxChunkSize = this.maxChunkSize;
        decoder.maxHeaderSize = this.maxHeaderSize;
        decoder.maxInitialLineLength = this.maxInitialLineLength;
        decoder.validateHeaders = this.validateHeaders;
        decoder.h2cMaxContentLength = this.h2cMaxContentLength;
        return tcp -> tcp.bootstrap(b -> HttpServerConfiguration.decoder(b, decoder));
    }
}

