/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd.internal;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.lang.Nullable;
import io.micrometer.statsd.internal.FlavorStatsdLineBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class DatadogStatsdLineBuilder
extends FlavorStatsdLineBuilder {
    private final Object conventionTagsLock = new Object();
    private volatile NamingConvention namingConvention;
    private volatile String name;
    @Nullable
    private volatile String conventionTags;
    private volatile String tagsNoStat;
    private final ConcurrentMap<Statistic, String> tags = new ConcurrentHashMap<Statistic, String>();

    public DatadogStatsdLineBuilder(Meter.Id id, MeterRegistry.Config config) {
        super(id, config);
    }

    @Override
    String line(String amount, @Nullable Statistic stat, String type) {
        this.updateIfNamingConventionChanged();
        return this.name + amount + "|" + type + this.tagsByStatistic(stat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIfNamingConventionChanged() {
        NamingConvention next = this.config.namingConvention();
        if (this.namingConvention != next) {
            this.namingConvention = next;
            this.name = next.name(this.sanitizeName(this.id.getName()), this.id.getType(), this.id.getBaseUnit()) + ":";
            Object object = this.conventionTagsLock;
            synchronized (object) {
                this.tags.clear();
                this.conventionTags = this.id.getTagsAsIterable().iterator().hasNext() ? this.id.getConventionTags(this.namingConvention).stream().map(t -> this.sanitizeName(t.getKey()) + ":" + this.sanitizeTagValue(t.getValue())).collect(Collectors.joining(",")) : null;
            }
            this.tagsNoStat = this.tags(null, this.conventionTags, ":", "|#");
        }
    }

    private String sanitizeName(String value) {
        if (!Character.isLetter(value.charAt(0))) {
            value = "m." + value;
        }
        return value.replace(':', '_');
    }

    private String sanitizeTagValue(String value) {
        return value.charAt(value.length() - 1) == ':' ? value.substring(0, value.length() - 1) + '_' : value;
    }

    private String tagsByStatistic(@Nullable Statistic stat) {
        return stat == null ? this.tagsNoStat : this.tags.computeIfAbsent(stat, this::ddTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String ddTag(@Nullable Statistic stat) {
        Object object = this.conventionTagsLock;
        synchronized (object) {
            return this.tags(stat, this.conventionTags, ":", "|#");
        }
    }
}

