/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.InnerOperator;
import io.micrometer.shaded.reactor.core.publisher.InternalFluxOperator;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.function.Tuple2;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;

final class FluxMetrics<T>
extends InternalFluxOperator<T, T> {
    final String name;
    final Tags tags;
    final MeterRegistry registryCandidate;
    static final String REACTOR_DEFAULT_NAME = "io.micrometer.shaded.reactor";
    static final String METER_MALFORMED = "io.micrometer.shaded.reactor.malformed.source";
    static final String METER_SUBSCRIBED = "io.micrometer.shaded.reactor.subscribed";
    static final String METER_FLOW_DURATION = "io.micrometer.shaded.reactor.flow.duration";
    static final String METER_ON_NEXT_DELAY = "io.micrometer.shaded.reactor.onNext.delay";
    static final String METER_REQUESTED = "io.micrometer.shaded.reactor.requested";
    static final String TAG_KEY_EXCEPTION = "exception";
    static final String TAG_SEQUENCE_NAME = "flow";
    static final Tags DEFAULT_TAGS_FLUX = Tags.of((String)"type", (String)"Flux");
    static final Tags DEFAULT_TAGS_MONO = Tags.of((String)"type", (String)"Mono");
    static final Tag TAG_ON_ERROR = Tag.of((String)"status", (String)"error");
    static final Tags TAG_ON_COMPLETE = Tags.of((String[])new String[]{"status", "completed", "exception", ""});
    static final Tags TAG_CANCEL = Tags.of((String[])new String[]{"status", "cancelled", "exception", ""});
    static final Logger log = Loggers.getLogger(FluxMetrics.class);
    static final BiFunction<Tags, Tuple2<String, String>, Tags> TAG_ACCUMULATOR = (prev, tuple) -> prev.and(new Tag[]{Tag.of((String)((String)tuple.getT1()), (String)((String)tuple.getT2()))});
    static final BinaryOperator<Tags> TAG_COMBINER = Tags::and;

    FluxMetrics(Flux<? extends T> flux) {
        this(flux, null);
    }

    FluxMetrics(Flux<? extends T> flux, @Nullable MeterRegistry registry) {
        super(flux);
        this.name = FluxMetrics.resolveName(flux);
        this.tags = FluxMetrics.resolveTags(flux, DEFAULT_TAGS_FLUX, this.name);
        this.registryCandidate = registry == null ? Metrics.globalRegistry : registry;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new MetricsSubscriber<T>(actual, this.registryCandidate, Clock.SYSTEM, this.name, this.tags);
    }

    static String resolveName(Publisher<?> source) {
        Scannable scannable = Scannable.from(source);
        if (scannable.isScanAvailable()) {
            String nameOrDefault = scannable.name();
            if (scannable.stepName().equals(nameOrDefault)) {
                return REACTOR_DEFAULT_NAME;
            }
            return nameOrDefault;
        }
        log.warn("Attempting to activate metrics but the upstream is not Scannable. You might want to use `name()` (and optionally `tags()`) right before `metrics()`");
        return REACTOR_DEFAULT_NAME;
    }

    static Tags resolveTags(Publisher<?> source, Tags tags, String sequenceName) {
        Scannable scannable = Scannable.from(source);
        tags = tags.and(new Tag[]{Tag.of((String)TAG_SEQUENCE_NAME, (String)sequenceName)});
        if (scannable.isScanAvailable()) {
            return scannable.tags().reduce(tags, TAG_ACCUMULATOR, TAG_COMBINER);
        }
        return tags;
    }

    static void recordCancel(Tags commonTags, MeterRegistry registry, Timer.Sample flowDuration) {
        Timer timer = Timer.builder((String)METER_FLOW_DURATION).tags((Iterable)commonTags.and((Iterable)TAG_CANCEL)).description("Times the duration elapsed between a subscription and the cancellation of the sequence").register(registry);
        flowDuration.stop(timer);
    }

    static void recordMalformed(Tags commonTags, MeterRegistry registry) {
        registry.counter(METER_MALFORMED, (Iterable)commonTags).increment();
    }

    static void recordOnError(Tags commonTags, MeterRegistry registry, Timer.Sample flowDuration, Throwable e) {
        Timer timer = Timer.builder((String)METER_FLOW_DURATION).tags((Iterable)commonTags.and(new Tag[]{TAG_ON_ERROR})).tag(TAG_KEY_EXCEPTION, e.getClass().getName()).description("Times the duration elapsed between a subscription and the onError termination of the sequence, with the exception name as a tag.").register(registry);
        flowDuration.stop(timer);
    }

    static void recordOnComplete(Tags commonTags, MeterRegistry registry, Timer.Sample flowDuration) {
        Timer timer = Timer.builder((String)METER_FLOW_DURATION).tags((Iterable)commonTags.and((Iterable)TAG_ON_COMPLETE)).description("Times the duration elapsed between a subscription and the onComplete termination of the sequence").register(registry);
        flowDuration.stop(timer);
    }

    static void recordOnSubscribe(Tags commonTags, MeterRegistry registry) {
        Counter.builder((String)METER_SUBSCRIBED).tags((Iterable)commonTags).baseUnit("subscribers").description("Counts how many Reactor sequences have been subscribed to").register(registry).increment();
    }

    static class MetricsSubscriber<T>
    implements InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        final Clock clock;
        final Tags commonTags;
        final MeterRegistry registry;
        final DistributionSummary requestedCounter;
        final Timer onNextIntervalTimer;
        Timer.Sample subscribeToTerminateSample;
        long lastNextEventNanos = -1L;
        boolean done;
        Subscription s;

        MetricsSubscriber(CoreSubscriber<? super T> actual, MeterRegistry registry, Clock clock, String sequenceName, Tags commonTags) {
            this.actual = actual;
            this.clock = clock;
            this.commonTags = commonTags;
            this.registry = registry;
            this.onNextIntervalTimer = Timer.builder((String)FluxMetrics.METER_ON_NEXT_DELAY).tags((Iterable)commonTags).description("Measures delays between onNext signals (or between onSubscribe and first onNext)").register(registry);
            this.requestedCounter = !FluxMetrics.REACTOR_DEFAULT_NAME.equals(sequenceName) ? DistributionSummary.builder((String)FluxMetrics.METER_REQUESTED).tags((Iterable)commonTags).description("Counts the amount requested to a named Flux by all subscribers, until at least one requests an unbounded amount").baseUnit("requested amount").register(registry) : null;
        }

        @Override
        public final CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public final void cancel() {
            FluxMetrics.recordCancel(this.commonTags, this.registry, this.subscribeToTerminateSample);
            this.s.cancel();
        }

        @Override
        public final void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            FluxMetrics.recordOnComplete(this.commonTags, this.registry, this.subscribeToTerminateSample);
            this.actual.onComplete();
        }

        @Override
        public final void onError(Throwable e) {
            if (this.done) {
                FluxMetrics.recordMalformed(this.commonTags, this.registry);
                Operators.onErrorDropped(e, this.actual.currentContext());
                return;
            }
            this.done = true;
            FluxMetrics.recordOnError(this.commonTags, this.registry, this.subscribeToTerminateSample, e);
            this.actual.onError(e);
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                FluxMetrics.recordMalformed(this.commonTags, this.registry);
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            long last = this.lastNextEventNanos;
            this.lastNextEventNanos = this.clock.monotonicTime();
            this.onNextIntervalTimer.record(this.lastNextEventNanos - last, TimeUnit.NANOSECONDS);
            this.actual.onNext(t);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                FluxMetrics.recordOnSubscribe(this.commonTags, this.registry);
                this.subscribeToTerminateSample = Timer.start((Clock)this.clock);
                this.lastNextEventNanos = this.clock.monotonicTime();
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public final void request(long l) {
            if (Operators.validate(l)) {
                if (this.requestedCounter != null) {
                    this.requestedCounter.record((double)l);
                }
                this.s.request(l);
            }
        }
    }
}

