/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.channel;

import io.micrometer.shaded.io.netty.resolver.AddressResolver;
import io.micrometer.shaded.io.netty.resolver.AddressResolverGroup;
import io.micrometer.shaded.io.netty.util.concurrent.EventExecutor;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.Promise;
import io.micrometer.shaded.reactor.netty.channel.ChannelMetricsRecorder;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class AddressResolverGroupMetrics
extends AddressResolverGroup<SocketAddress> {
    final AddressResolverGroup<SocketAddress> resolverGroup;
    final ChannelMetricsRecorder recorder;

    AddressResolverGroupMetrics(AddressResolverGroup<SocketAddress> resolverGroup, @Nullable ChannelMetricsRecorder recorder) {
        this.resolverGroup = resolverGroup;
        this.recorder = recorder;
    }

    @Override
    protected AddressResolver<SocketAddress> newResolver(EventExecutor executor) {
        final AddressResolver<SocketAddress> resolver = this.resolverGroup.getResolver(executor);
        return new AddressResolver<SocketAddress>(){

            @Override
            public boolean isSupported(SocketAddress address) {
                return resolver.isSupported(address);
            }

            @Override
            public boolean isResolved(SocketAddress address) {
                return resolver.isResolved(address);
            }

            @Override
            public Future<SocketAddress> resolve(SocketAddress address) {
                return this.resolveInternal(address, () -> resolver.resolve(address));
            }

            @Override
            public Future<SocketAddress> resolve(SocketAddress address, Promise<SocketAddress> promise) {
                return this.resolveInternal(address, () -> resolver.resolve(address, promise));
            }

            @Override
            public Future<List<SocketAddress>> resolveAll(SocketAddress address) {
                return this.resolveAllInternal(address, () -> resolver.resolveAll(address));
            }

            @Override
            public Future<List<SocketAddress>> resolveAll(SocketAddress address, Promise<List<SocketAddress>> promise) {
                return this.resolveAllInternal(address, () -> resolver.resolveAll(address, promise));
            }

            @Override
            public void close() {
                resolver.close();
            }

            Future<SocketAddress> resolveInternal(SocketAddress address, Supplier<Future<SocketAddress>> resolver2) {
                long resolveTimeStart = System.nanoTime();
                return resolver2.get().addListener(future -> this.record(resolveTimeStart, future.isSuccess() ? "SUCCESS" : "ERROR", address));
            }

            Future<List<SocketAddress>> resolveAllInternal(SocketAddress address, Supplier<Future<List<SocketAddress>>> resolver2) {
                long resolveTimeStart = System.nanoTime();
                return resolver2.get().addListener(future -> this.record(resolveTimeStart, future.isSuccess() ? "SUCCESS" : "ERROR", address));
            }

            void record(long resolveTimeStart, String status, SocketAddress remoteAddress) {
                AddressResolverGroupMetrics.this.recorder.recordResolveAddressTime(remoteAddress, Duration.ofNanos(System.nanoTime() - resolveTimeStart), status);
            }
        };
    }
}

