/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.server;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.ByteBufHolder;
import io.micrometer.shaded.io.netty.channel.ChannelDuplexHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.channel.socket.SocketChannel;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpMessage;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpResponse;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpUtil;
import io.micrometer.shaded.io.netty.handler.codec.http.LastHttpContent;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.micrometer.shaded.reactor.netty.http.server.AccessLog;

final class AccessLogHandler
extends ChannelDuplexHandler {
    AccessLog accessLog = new AccessLog();

    AccessLogHandler() {
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            SocketChannel channel = (SocketChannel)ctx.channel();
            this.accessLog = new AccessLog().address(channel.remoteAddress().getHostString()).port(channel.localAddress().getPort()).method(request.method().name()).uri(request.uri()).protocol(request.protocolVersion().text());
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            HttpResponseStatus status = response.status();
            if (status.equals(HttpResponseStatus.CONTINUE)) {
                ctx.write(msg, promise);
                return;
            }
            boolean chunked = HttpUtil.isTransferEncodingChunked(response);
            this.accessLog.status(status.codeAsText()).chunked(chunked);
            if (!chunked) {
                this.accessLog.contentLength(HttpUtil.getContentLength((HttpMessage)response, -1));
            }
        }
        if (msg instanceof LastHttpContent) {
            this.accessLog.increaseContentLength(((LastHttpContent)msg).content().readableBytes());
            ctx.write(msg, promise.unvoid()).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (future.isSuccess()) {
                    this.accessLog.log();
                }
            }));
            return;
        }
        if (msg instanceof ByteBuf) {
            this.accessLog.increaseContentLength(((ByteBuf)msg).readableBytes());
        }
        if (msg instanceof ByteBufHolder) {
            this.accessLog.increaseContentLength(((ByteBufHolder)msg).content().readableBytes());
        }
        ctx.write(msg, promise);
    }
}

