/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.server;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.Unpooled;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelFuture;
import io.micrometer.shaded.io.netty.channel.ChannelFutureListener;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.handler.codec.DecoderException;
import io.micrometer.shaded.io.netty.handler.codec.TooLongFrameException;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultHttpResponse;
import io.micrometer.shaded.io.netty.handler.codec.http.FullHttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.FullHttpResponse;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpContent;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpMessage;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpMethod;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpResponse;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpUtil;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpVersion;
import io.micrometer.shaded.io.netty.handler.codec.http.LastHttpContent;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.Cookie;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.micrometer.shaded.io.netty.handler.codec.http2.HttpConversionUtil;
import io.micrometer.shaded.io.netty.util.AsciiString;
import io.micrometer.shaded.io.netty.util.ReferenceCountUtil;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.FutureMono;
import io.micrometer.shaded.reactor.netty.NettyOutbound;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.netty.http.Cookies;
import io.micrometer.shaded.reactor.netty.http.HttpOperations;
import io.micrometer.shaded.reactor.netty.http.server.ConnectionInfo;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerRequest;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerResponse;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerState;
import io.micrometer.shaded.reactor.netty.http.server.SimpleCompressionHandler;
import io.micrometer.shaded.reactor.netty.http.server.WebsocketServerOperations;
import io.micrometer.shaded.reactor.netty.http.server.WebsocketServerSpec;
import io.micrometer.shaded.reactor.netty.http.websocket.WebsocketInbound;
import io.micrometer.shaded.reactor.netty.http.websocket.WebsocketOutbound;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import io.micrometer.shaded.reactor.util.context.Context;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

class HttpServerOperations
extends HttpOperations<HttpServerRequest, HttpServerResponse>
implements HttpServerRequest,
HttpServerResponse {
    final HttpResponse nettyResponse;
    final HttpHeaders responseHeaders;
    final Cookies cookieHolder;
    final HttpRequest nettyRequest;
    final String path;
    final ConnectionInfo connectionInfo;
    final ServerCookieEncoder cookieEncoder;
    final ServerCookieDecoder cookieDecoder;
    final BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate;
    Function<? super String, Map<String, String>> paramsResolver;
    static final Logger log = Loggers.getLogger(HttpServerOperations.class);
    static final AsciiString EVENT_STREAM = new AsciiString("text/event-stream");
    static final FullHttpResponse CONTINUE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);

    HttpServerOperations(HttpServerOperations replaced) {
        super(replaced);
        this.cookieHolder = replaced.cookieHolder;
        this.connectionInfo = replaced.connectionInfo;
        this.responseHeaders = replaced.responseHeaders;
        this.nettyResponse = replaced.nettyResponse;
        this.paramsResolver = replaced.paramsResolver;
        this.nettyRequest = replaced.nettyRequest;
        this.path = replaced.path;
        this.compressionPredicate = replaced.compressionPredicate;
        this.cookieEncoder = replaced.cookieEncoder;
        this.cookieDecoder = replaced.cookieDecoder;
    }

    HttpServerOperations(Connection c, ConnectionObserver listener, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate, HttpRequest nettyRequest, ConnectionInfo connectionInfo, ServerCookieEncoder encoder, ServerCookieDecoder decoder) {
        super(c, listener);
        this.nettyRequest = nettyRequest;
        this.path = HttpServerOperations.resolvePath(nettyRequest.uri());
        this.nettyResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        this.responseHeaders = this.nettyResponse.headers();
        this.responseHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        this.compressionPredicate = compressionPredicate;
        this.cookieHolder = Cookies.newServerRequestHolder(this.requestHeaders(), decoder);
        this.connectionInfo = connectionInfo;
        this.cookieEncoder = encoder;
        this.cookieDecoder = decoder;
    }

    @Override
    public NettyOutbound sendHeaders() {
        if (this.hasSentHeaders()) {
            return this;
        }
        return this.then(Mono.empty());
    }

    @Override
    public HttpServerOperations withConnection(Consumer<? super Connection> withConnection) {
        Objects.requireNonNull(withConnection, "withConnection");
        withConnection.accept(this);
        return this;
    }

    @Override
    protected HttpMessage newFullBodyMessage(ByteBuf body) {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(this.version(), this.status(), body);
        this.responseHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING);
        if (!HttpResponseStatus.NOT_MODIFIED.equals(this.status()) && HttpUtil.getContentLength((HttpMessage)this.nettyResponse, -1) == -1) {
            this.responseHeaders.setInt(HttpHeaderNames.CONTENT_LENGTH, body.readableBytes());
        }
        res.headers().set(this.responseHeaders);
        return res;
    }

    @Override
    public HttpServerResponse addCookie(Cookie cookie) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)this.cookieEncoder.encode(cookie));
        return this;
    }

    @Override
    public HttpServerResponse addHeader(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.add(name, (Object)value);
        return this;
    }

    @Override
    public HttpServerOperations chunkedTransfer(boolean chunked) {
        if (!this.hasSentHeaders() && HttpUtil.isTransferEncodingChunked(this.nettyResponse) != chunked) {
            this.responseHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING);
            HttpUtil.setTransferEncodingChunked(this.nettyResponse, chunked);
        }
        return this;
    }

    @Override
    public Map<CharSequence, Set<Cookie>> cookies() {
        if (this.cookieHolder != null) {
            return this.cookieHolder.getCachedCookies();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public HttpServerResponse header(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.set(name, (Object)value);
        return this;
    }

    @Override
    public HttpServerResponse headers(HttpHeaders headers) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.set(headers);
        return this;
    }

    @Override
    public boolean isKeepAlive() {
        return HttpUtil.isKeepAlive(this.nettyRequest);
    }

    @Override
    public boolean isWebsocket() {
        return HttpServerOperations.get(this.channel()) instanceof WebsocketServerOperations;
    }

    boolean isHttp2() {
        return this.requestHeaders().contains(HttpConversionUtil.ExtensionHeaderNames.SCHEME.text());
    }

    @Override
    public HttpServerResponse keepAlive(boolean keepAlive) {
        HttpUtil.setKeepAlive(this.nettyResponse, keepAlive);
        return this;
    }

    @Override
    public HttpMethod method() {
        return this.nettyRequest.method();
    }

    @Override
    @Nullable
    public String param(CharSequence key) {
        Objects.requireNonNull(key, "key");
        Map<String, String> params = null;
        if (this.paramsResolver != null) {
            params = this.paramsResolver.apply(this.uri());
        }
        return null != params ? params.get(key.toString()) : null;
    }

    @Override
    @Nullable
    public Map<String, String> params() {
        return null != this.paramsResolver ? this.paramsResolver.apply(this.uri()) : null;
    }

    @Override
    public HttpServerRequest paramsResolver(Function<? super String, Map<String, String>> paramsResolver) {
        this.paramsResolver = paramsResolver;
        return this;
    }

    @Override
    public Flux<?> receiveObject() {
        if (HttpUtil.is100ContinueExpected(this.nettyRequest)) {
            return FutureMono.deferFuture(() -> {
                if (!this.hasSentHeaders()) {
                    return this.channel().writeAndFlush(CONTINUE);
                }
                return this.channel().newSucceededFuture();
            }).thenMany(super.receiveObject());
        }
        return super.receiveObject();
    }

    @Override
    public InetSocketAddress hostAddress() {
        return this.connectionInfo.getHostAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.connectionInfo.getRemoteAddress();
    }

    @Override
    public HttpHeaders requestHeaders() {
        if (this.nettyRequest != null) {
            return this.nettyRequest.headers();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public String scheme() {
        return this.connectionInfo.getScheme();
    }

    @Override
    public HttpHeaders responseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public Mono<Void> send() {
        if (this.markSentHeaderAndBody(new Object[0])) {
            HttpMessage response = this.newFullBodyMessage(Unpooled.EMPTY_BUFFER);
            return FutureMono.deferFuture(() -> this.channel().writeAndFlush(response));
        }
        return Mono.empty();
    }

    @Override
    public NettyOutbound sendFile(Path file) {
        try {
            return this.sendFile(file, 0L, Files.size(file));
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Path not resolved"), e);
            }
            return this.then(this.sendNotFound());
        }
    }

    @Override
    public Mono<Void> sendNotFound() {
        return this.status(HttpResponseStatus.NOT_FOUND).send();
    }

    @Override
    public Mono<Void> sendRedirect(String location) {
        Objects.requireNonNull(location, "location");
        return this.status(HttpResponseStatus.FOUND).header(HttpHeaderNames.LOCATION, location).send();
    }

    @Override
    public HttpServerResponse sse() {
        this.header(HttpHeaderNames.CONTENT_TYPE, EVENT_STREAM);
        return this;
    }

    @Override
    public HttpResponseStatus status() {
        return HttpResponseStatus.valueOf(this.nettyResponse.status().code());
    }

    @Override
    public HttpServerResponse status(HttpResponseStatus status) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.nettyResponse.setStatus(status);
        return this;
    }

    @Override
    public Mono<Void> sendWebsocket(BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler, WebsocketServerSpec configurer) {
        return this.withWebsocketSupport(this.uri(), configurer, websocketHandler);
    }

    @Override
    public String uri() {
        if (this.nettyRequest != null) {
            return this.nettyRequest.uri();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public String fullPath() {
        if (this.path != null) {
            return this.path;
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public HttpVersion version() {
        if (this.nettyRequest != null) {
            return this.nettyRequest.protocolVersion();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public HttpServerResponse compression(boolean compress) {
        if (!compress) {
            this.removeHandler("io.micrometer.shaded.reactor.left.compressionHandler");
        } else if (this.channel().pipeline().get("io.micrometer.shaded.reactor.left.compressionHandler") == null) {
            SimpleCompressionHandler handler = new SimpleCompressionHandler();
            try {
                ArrayList<Object> out = new ArrayList<Object>();
                try {
                    handler.decode(this.channel().pipeline().context("io.micrometer.shaded.reactor.right.reactiveBridge"), this.nettyRequest, (List<Object>)out);
                }
                catch (DecoderException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DecoderException(e);
                }
                finally {
                    ReferenceCountUtil.release(this.nettyRequest);
                    out.clear();
                }
                this.addHandlerFirst("io.micrometer.shaded.reactor.left.compressionHandler", handler);
            }
            catch (Throwable e) {
                log.error(ReactorNetty.format(this.channel(), ""), e);
            }
        }
        return this;
    }

    @Override
    protected void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            try {
                this.listener().onStateChange(this, HttpServerState.REQUEST_RECEIVED);
            }
            catch (Exception e) {
                this.onInboundError(e);
                ReferenceCountUtil.release(msg);
                return;
            }
            if (msg instanceof FullHttpRequest) {
                FullHttpRequest request = (FullHttpRequest)msg;
                if (request.content().readableBytes() > 0) {
                    super.onInboundNext(ctx, msg);
                } else {
                    request.release();
                }
                if (this.isHttp2()) {
                    this.channel().config().setAutoRead(true);
                    this.onInboundComplete();
                }
            }
            return;
        }
        if (msg instanceof HttpContent) {
            if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
                super.onInboundNext(ctx, msg);
            }
            if (msg instanceof LastHttpContent) {
                this.channel().config().setAutoRead(true);
                this.onInboundComplete();
            }
        } else {
            super.onInboundNext(ctx, msg);
        }
    }

    @Override
    protected void afterMarkSentHeaders() {
        if (HttpResponseStatus.NOT_MODIFIED.equals(this.status())) {
            this.responseHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING).remove(HttpHeaderNames.CONTENT_LENGTH);
        }
        if (this.compressionPredicate != null && this.compressionPredicate.test(this, this)) {
            this.compression(true);
        }
    }

    @Override
    protected void beforeMarkSentHeaders() {
    }

    @Override
    protected void onOutboundComplete() {
        ChannelFuture f;
        if (this.isWebsocket()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(this.channel(), "Last HTTP response frame"));
        }
        if (this.markSentHeaderAndBody(new Object[0])) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "No sendHeaders() called before complete, sending zero-length header"));
            }
            f = this.channel().writeAndFlush(this.newFullBodyMessage(Unpooled.EMPTY_BUFFER));
        } else if (this.markSentBody()) {
            f = this.channel().writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
        } else {
            this.discard();
            return;
        }
        f.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)s -> {
            this.discard();
            if (!s.isSuccess() && log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Failed flushing last frame"), s.cause());
            }
        }));
    }

    static void cleanHandlerTerminate(Channel ch) {
        ChannelOperations<?, ?> ops = HttpServerOperations.get(ch);
        if (ops == null) {
            return;
        }
        if (!ops.isSubscriptionDisposed()) {
            ch.eventLoop().execute(((HttpServerOperations)ops)::terminate);
        } else {
            ((HttpServerOperations)ops).terminate();
        }
    }

    static void sendDecodingFailures(ChannelHandlerContext ctx, Throwable t, Object msg) {
        Throwable cause;
        Throwable throwable = cause = t.getCause() != null ? t.getCause() : t;
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(ctx.channel(), "Decoding failed: " + msg + " : "), cause);
        }
        ReferenceCountUtil.release(msg);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_0, cause instanceof TooLongFrameException ? HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE : HttpResponseStatus.BAD_REQUEST);
        response.headers().setInt(HttpHeaderNames.CONTENT_LENGTH, 0).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        ctx.writeAndFlush(response).addListener(ChannelFutureListener.CLOSE);
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (!this.channel().isActive()) {
            super.onOutboundError(err);
            return;
        }
        if (this.markSentHeaders(new Object[0])) {
            log.error(ReactorNetty.format(this.channel(), "Error starting response. Replying error status"), err);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            response.headers().set(this.responseHeaders).remove(HttpHeaderNames.TRANSFER_ENCODING).setInt(HttpHeaderNames.CONTENT_LENGTH, 0).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            this.channel().writeAndFlush(response).addListener(ChannelFutureListener.CLOSE);
            return;
        }
        this.markSentBody();
        log.error(ReactorNetty.format(this.channel(), "Error finishing response. Closing connection"), err);
        this.channel().writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
    }

    @Override
    protected HttpMessage outboundHttpMessage() {
        return this.nettyResponse;
    }

    final Mono<Void> withWebsocketSupport(String url, WebsocketServerSpec websocketServerSpec, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        Objects.requireNonNull(websocketServerSpec, "websocketServerSpec");
        Objects.requireNonNull(websocketHandler, "websocketHandler");
        if (this.markSentHeaders(new Object[0])) {
            WebsocketServerOperations ops = new WebsocketServerOperations(url, websocketServerSpec, this);
            return FutureMono.from(ops.handshakerResult).doOnEach(signal -> {
                if (!(signal.hasError() || websocketServerSpec.protocols() != null && ops.selectedSubprotocol() == null)) {
                    ((Publisher)websocketHandler.apply(ops, ops)).subscribe(new WebsocketSubscriber(ops, signal.getContext()));
                }
            });
        }
        log.error(ReactorNetty.format(this.channel(), "Cannot enable websocket if headers have already been sent"));
        return Mono.error(new IllegalStateException("Failed to upgrade to websocket"));
    }

    static final class WebsocketSubscriber
    implements CoreSubscriber<Void>,
    ChannelFutureListener {
        final WebsocketServerOperations ops;
        final Context context;

        WebsocketSubscriber(WebsocketServerOperations ops, Context context) {
            this.ops = ops;
            this.context = context;
        }

        @Override
        public void onSubscribe(Subscription s) {
            s.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(Void aVoid) {
        }

        @Override
        public void onError(Throwable t) {
            this.ops.onError(t);
        }

        @Override
        public void operationComplete(ChannelFuture future) {
            ((HttpServerOperations)this.ops).terminate();
        }

        @Override
        public void onComplete() {
            if (this.ops.channel().isActive()) {
                this.ops.sendCloseNow(null, this);
            }
        }

        @Override
        public Context currentContext() {
            return this.context;
        }
    }
}

