/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.server;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Timer;
import io.micrometer.shaded.reactor.netty.Metrics;
import io.micrometer.shaded.reactor.netty.channel.MeterKey;
import io.micrometer.shaded.reactor.netty.http.MicrometerHttpMetricsRecorder;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerMetricsRecorder;
import java.net.SocketAddress;
import java.time.Duration;

final class MicrometerHttpServerMetricsRecorder
extends MicrometerHttpMetricsRecorder
implements HttpServerMetricsRecorder {
    static final MicrometerHttpServerMetricsRecorder INSTANCE = new MicrometerHttpServerMetricsRecorder();

    private MicrometerHttpServerMetricsRecorder() {
        super("io.micrometer.shaded.reactor.netty.http.server", "http");
    }

    @Override
    public void recordDataReceivedTime(String uri, String method, Duration time) {
        Timer dataReceivedTime = this.dataReceivedTimeCache.computeIfAbsent(new MeterKey(uri, null, method, null), key -> MicrometerHttpServerMetricsRecorder.filter(this.dataReceivedTimeBuilder.tags(new String[]{"uri", uri, "method", method}).register(Metrics.REGISTRY)));
        if (dataReceivedTime != null) {
            dataReceivedTime.record(time);
        }
    }

    @Override
    public void recordDataSentTime(String uri, String method, String status, Duration time) {
        Timer dataSentTime = this.dataSentTimeCache.computeIfAbsent(new MeterKey(uri, null, method, status), key -> MicrometerHttpServerMetricsRecorder.filter(this.dataSentTimeBuilder.tags(new String[]{"uri", uri, "method", method, "status", status}).register(Metrics.REGISTRY)));
        if (dataSentTime != null) {
            dataSentTime.record(time);
        }
    }

    @Override
    public void recordResponseTime(String uri, String method, String status, Duration time) {
        Timer responseTime = this.responseTimeCache.computeIfAbsent(new MeterKey(uri, null, method, status), key -> MicrometerHttpServerMetricsRecorder.filter(this.responseTimeBuilder.tags(new String[]{"uri", uri, "method", method, "status", status}).register(Metrics.REGISTRY)));
        if (responseTime != null) {
            responseTime.record(time);
        }
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, String uri, long bytes) {
        DistributionSummary dataReceived = this.dataReceivedCache.computeIfAbsent(new MeterKey(uri, null, null, null), key -> MicrometerHttpServerMetricsRecorder.filter(this.dataReceivedBuilder.tags(new String[]{"uri", uri}).register(Metrics.REGISTRY)));
        if (dataReceived != null) {
            dataReceived.record((double)bytes);
        }
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, String uri, long bytes) {
        DistributionSummary dataSent = this.dataSentCache.computeIfAbsent(new MeterKey(uri, null, null, null), key -> MicrometerHttpServerMetricsRecorder.filter(this.dataSentBuilder.tags(new String[]{"uri", uri}).register(Metrics.REGISTRY)));
        if (dataSent != null) {
            dataSent.record((double)bytes);
        }
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress, String uri) {
        Counter errors = this.errorsCache.computeIfAbsent(new MeterKey(uri, null, null, null), key -> MicrometerHttpServerMetricsRecorder.filter(this.errorsBuilder.tags(new String[]{"uri", uri}).register(Metrics.REGISTRY)));
        if (errors != null) {
            errors.increment();
        }
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, long bytes) {
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, long bytes) {
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress) {
    }

    @Override
    public void recordTlsHandshakeTime(SocketAddress remoteAddress, Duration time, String status) {
    }

    @Override
    public void recordConnectTime(SocketAddress remoteAddress, Duration time, String status) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void recordResolveAddressTime(SocketAddress remoteAddress, Duration time, String status) {
        throw new UnsupportedOperationException();
    }
}

