/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.server;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.channel.ChannelDuplexHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.channel.socket.SocketChannel;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultHttpContent;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.micrometer.shaded.io.netty.handler.ssl.SslHandler;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.http.server.ConnectionInfo;
import io.micrometer.shaded.reactor.netty.http.server.HAProxyMessageReader;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerOperations;
import java.net.InetSocketAddress;
import java.util.Optional;

final class Http2StreamBridgeHandler
extends ChannelDuplexHandler {
    final boolean readForwardHeaders;
    Boolean secured;
    InetSocketAddress remoteAddress;
    final ConnectionObserver listener;
    final ServerCookieEncoder cookieEncoder;
    final ServerCookieDecoder cookieDecoder;

    Http2StreamBridgeHandler(ConnectionObserver listener, boolean readForwardHeaders, ServerCookieEncoder encoder, ServerCookieDecoder decoder) {
        this.readForwardHeaders = readForwardHeaders;
        this.listener = listener;
        this.cookieEncoder = encoder;
        this.cookieDecoder = decoder;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "New http2 connection, requesting read"));
        }
        ctx.read();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.secured == null) {
            this.secured = ctx.channel().parent().pipeline().get(SslHandler.class) != null;
        }
        if (this.remoteAddress == null) {
            this.remoteAddress = Optional.ofNullable(HAProxyMessageReader.resolveRemoteAddressFromProxyProtocol(ctx.channel().parent())).orElse(((SocketChannel)ctx.channel().parent()).remoteAddress());
        }
        if (msg instanceof HttpRequest) {
            HttpServerOperations ops;
            HttpRequest request = (HttpRequest)msg;
            try {
                ops = new HttpServerOperations(Connection.from(ctx.channel()), this.listener, null, request, ConnectionInfo.from(ctx.channel().parent(), this.readForwardHeaders, request, this.secured, this.remoteAddress), this.cookieEncoder, this.cookieDecoder);
            }
            catch (RuntimeException e) {
                HttpServerOperations.sendDecodingFailures(ctx, e, msg);
                return;
            }
            ops.bind();
            this.listener.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            ctx.write(new DefaultHttpContent((ByteBuf)msg), promise);
        } else {
            ctx.write(msg, promise);
        }
    }
}

