/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.InnerOperator;
import io.micrometer.shaded.reactor.core.publisher.InternalFluxOperator;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

final class FluxLimitRequest<T>
extends InternalFluxOperator<T, T> {
    final long cap;

    FluxLimitRequest(Flux<T> flux, long cap) {
        super(flux);
        this.cap = cap;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new FluxLimitRequestSubscriber<T>(actual, this.cap);
    }

    @Override
    public int getPrefetch() {
        return 0;
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
            return this.cap;
        }
        return super.scanUnsafe(key);
    }

    static class FluxLimitRequestSubscriber<T>
    implements InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        Subscription parent;
        long toProduce;
        volatile long requestRemaining;
        static final AtomicLongFieldUpdater<FluxLimitRequestSubscriber> REQUEST_REMAINING = AtomicLongFieldUpdater.newUpdater(FluxLimitRequestSubscriber.class, "requestRemaining");

        FluxLimitRequestSubscriber(CoreSubscriber<? super T> actual, long cap) {
            this.actual = actual;
            this.toProduce = cap;
            this.requestRemaining = cap;
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public void onNext(T t) {
            long r = this.toProduce;
            if (r > 0L) {
                this.toProduce = --r;
                this.actual.onNext(t);
                if (r == 0L) {
                    this.parent.cancel();
                    this.actual.onComplete();
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.toProduce != 0L) {
                this.toProduce = 0L;
                this.actual.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (this.toProduce != 0L) {
                this.toProduce = 0L;
                this.actual.onComplete();
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.parent = s;
            this.actual.onSubscribe(this);
        }

        @Override
        public void request(long l) {
            block1: {
                long newRequest;
                long u;
                long r;
                while (!REQUEST_REMAINING.compareAndSet(this, r, u = r - (newRequest = (r = this.requestRemaining) <= l ? r : l))) {
                }
                if (newRequest == 0L) break block1;
                this.parent.request(newRequest);
            }
        }

        @Override
        public void cancel() {
            this.parent.cancel();
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.parent;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.toProduce == 0L;
            }
            return InnerOperator.super.scanUnsafe(key);
        }
    }
}

