/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http;

import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.resources.ConnectionProvider;
import io.micrometer.shaded.reactor.netty.resources.LoopResources;
import io.micrometer.shaded.reactor.netty.tcp.TcpResources;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;

public final class HttpResources
extends TcpResources {
    static final AtomicReference<HttpResources> httpResources;
    static final BiFunction<LoopResources, ConnectionProvider, HttpResources> ON_HTTP_NEW;

    public static HttpResources get() {
        return HttpResources.getOrCreate(httpResources, null, null, ON_HTTP_NEW, "http");
    }

    public static HttpResources set(ConnectionProvider provider) {
        return HttpResources.getOrCreate(httpResources, null, provider, ON_HTTP_NEW, "http");
    }

    public static HttpResources set(LoopResources loops) {
        return HttpResources.getOrCreate(httpResources, loops, null, ON_HTTP_NEW, "http");
    }

    public static HttpResources reset() {
        HttpResources.disposeLoopsAndConnections();
        return HttpResources.getOrCreate(httpResources, null, null, ON_HTTP_NEW, "http");
    }

    public static void disposeLoopsAndConnections() {
        HttpResources resources = httpResources.getAndSet(null);
        if (resources != null) {
            resources._dispose();
        }
    }

    public static Mono<Void> disposeLoopsAndConnectionsLater() {
        return HttpResources.disposeLoopsAndConnectionsLater(Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_QUIET_PERIOD), Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_TIMEOUT));
    }

    public static Mono<Void> disposeLoopsAndConnectionsLater(Duration quietPeriod, Duration timeout) {
        return Mono.defer(() -> {
            HttpResources resources = httpResources.getAndSet(null);
            if (resources != null) {
                return resources._disposeLater(quietPeriod, timeout);
            }
            return Mono.empty();
        });
    }

    HttpResources(LoopResources loops, ConnectionProvider provider) {
        super(loops, provider);
    }

    static {
        ON_HTTP_NEW = HttpResources::new;
        httpResources = new AtomicReference();
    }
}

