/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.server;

import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.Cookie;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.NettyOutbound;
import io.micrometer.shaded.reactor.netty.http.HttpInfos;
import io.micrometer.shaded.reactor.netty.http.server.WebsocketServerSpec;
import io.micrometer.shaded.reactor.netty.http.websocket.WebsocketInbound;
import io.micrometer.shaded.reactor.netty.http.websocket.WebsocketOutbound;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public interface HttpServerResponse
extends NettyOutbound,
HttpInfos {
    public HttpServerResponse addCookie(Cookie var1);

    public HttpServerResponse addHeader(CharSequence var1, CharSequence var2);

    public HttpServerResponse chunkedTransfer(boolean var1);

    @Override
    public HttpServerResponse withConnection(Consumer<? super Connection> var1);

    public HttpServerResponse compression(boolean var1);

    public boolean hasSentHeaders();

    public HttpServerResponse header(CharSequence var1, CharSequence var2);

    public HttpServerResponse headers(HttpHeaders var1);

    public HttpServerResponse keepAlive(boolean var1);

    public HttpHeaders responseHeaders();

    public Mono<Void> send();

    public NettyOutbound sendHeaders();

    public Mono<Void> sendNotFound();

    public Mono<Void> sendRedirect(String var1);

    default public Mono<Void> sendWebsocket(BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        return this.sendWebsocket(websocketHandler, WebsocketServerSpec.builder().build());
    }

    @Deprecated
    default public Mono<Void> sendWebsocket(boolean proxyPing, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        return this.sendWebsocket(null, 65536, proxyPing, websocketHandler);
    }

    @Deprecated
    default public Mono<Void> sendWebsocket(@Nullable String protocols, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        return this.sendWebsocket(protocols, 65536, websocketHandler);
    }

    @Deprecated
    default public Mono<Void> sendWebsocket(@Nullable String protocols, int maxFramePayloadLength, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        return this.sendWebsocket(protocols, maxFramePayloadLength, false, websocketHandler);
    }

    @Deprecated
    default public Mono<Void> sendWebsocket(@Nullable String protocols, int maxFramePayloadLength, boolean proxyPing, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        return this.sendWebsocket(websocketHandler, ((WebsocketServerSpec.Builder)((WebsocketServerSpec.Builder)((WebsocketServerSpec.Builder)WebsocketServerSpec.builder().protocols(protocols)).maxFramePayloadLength(maxFramePayloadLength)).handlePing(proxyPing)).build());
    }

    public Mono<Void> sendWebsocket(BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> var1, WebsocketServerSpec var2);

    public HttpServerResponse sse();

    public HttpResponseStatus status();

    public HttpServerResponse status(HttpResponseStatus var1);

    default public HttpServerResponse status(int status) {
        return this.status(HttpResponseStatus.valueOf(status));
    }
}

