/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.client;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.micrometer.shaded.reactor.netty.http.client.HttpClient;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientConfiguration;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientOperator;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

final class HttpClientHeaders
extends HttpClientOperator
implements Function<Bootstrap, Bootstrap> {
    final Consumer<? super HttpHeaders> headers;

    HttpClientHeaders(HttpClient client, Consumer<? super HttpHeaders> headers) {
        super(client);
        this.headers = Objects.requireNonNull(headers, "headers");
    }

    @Override
    protected TcpClient tcpConfiguration() {
        return this.source.tcpConfiguration().bootstrap(this);
    }

    @Override
    public Bootstrap apply(Bootstrap bootstrap) {
        HttpHeaders h = HttpClientConfiguration.headers(bootstrap);
        if (h == null) {
            h = new DefaultHttpHeaders();
        }
        this.headers.accept(h);
        if (!h.isEmpty()) {
            HttpClientConfiguration.headers(bootstrap, h);
        }
        return bootstrap;
    }
}

