/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.server;

import io.micrometer.shaded.io.netty.channel.ChannelDuplexHandler;
import io.micrometer.shaded.io.netty.channel.ChannelFuture;
import io.micrometer.shaded.io.netty.channel.ChannelFutureListener;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.channel.socket.SocketChannel;
import io.micrometer.shaded.io.netty.handler.codec.DecoderResult;
import io.micrometer.shaded.io.netty.handler.codec.DecoderResultProvider;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpResponse;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpStatusClass;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpUtil;
import io.micrometer.shaded.io.netty.handler.codec.http.LastHttpContent;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.micrometer.shaded.io.netty.handler.ssl.SslHandler;
import io.micrometer.shaded.io.netty.util.ReferenceCountUtil;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.http.server.ConnectionInfo;
import io.micrometer.shaded.reactor.netty.http.server.HAProxyMessageReader;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerOperations;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerRequest;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerResponse;
import io.micrometer.shaded.reactor.util.concurrent.Queues;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;

final class HttpTrafficHandler
extends ChannelDuplexHandler
implements Runnable,
ChannelFutureListener {
    static final String MULTIPART_PREFIX = "multipart";
    final ConnectionObserver listener;
    Boolean secure;
    InetSocketAddress remoteAddress;
    final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
    final BiPredicate<HttpServerRequest, HttpServerResponse> compress;
    final ServerCookieEncoder cookieEncoder;
    final ServerCookieDecoder cookieDecoder;
    boolean persistentConnection = true;
    int pendingResponses;
    Queue<Object> pipelined;
    ChannelHandlerContext ctx;
    boolean overflow;
    boolean nonInformationalResponse;

    HttpTrafficHandler(ConnectionObserver listener, BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compress, @Nullable ServerCookieEncoder encoder, ServerCookieDecoder decoder) {
        this.listener = listener;
        this.forwardedHeaderHandler = forwardedHeaderHandler;
        this.compress = compress;
        this.cookieEncoder = encoder;
        this.cookieDecoder = decoder;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.ctx = ctx;
        if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "New http connection, requesting read"));
        }
        ctx.read();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        DecoderResult decoderResult;
        if (this.secure == null) {
            this.secure = ctx.channel().pipeline().get(SslHandler.class) != null;
        }
        if (this.remoteAddress == null) {
            this.remoteAddress = Optional.ofNullable(HAProxyMessageReader.resolveRemoteAddressFromProxyProtocol(ctx.channel())).orElse(((SocketChannel)ctx.channel()).remoteAddress());
        }
        if (msg instanceof HttpRequest) {
            HttpServerOperations ops;
            HttpRequest request = (HttpRequest)msg;
            if (this.persistentConnection) {
                ++this.pendingResponses;
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Increasing pending responses, now {}"), this.pendingResponses);
                }
            } else {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Dropping pipelined HTTP request, previous response requested connection close"));
                }
                ReferenceCountUtil.release(msg);
                return;
            }
            this.persistentConnection = HttpUtil.isKeepAlive(request);
            if (this.pendingResponses > 1) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Buffering pipelined HTTP request, pending response count: {}, queue: {}"), this.pendingResponses, this.pipelined != null ? this.pipelined.size() : 0);
                }
                this.overflow = true;
                this.doPipeline(ctx, msg);
                return;
            }
            this.overflow = false;
            DecoderResult decoderResult2 = request.decoderResult();
            if (decoderResult2.isFailure()) {
                this.sendDecodingFailures(decoderResult2.cause(), msg);
                return;
            }
            try {
                ops = new HttpServerOperations(Connection.from(ctx.channel()), this.listener, this.compress, request, ConnectionInfo.from(ctx.channel(), request, this.secure, this.remoteAddress, this.forwardedHeaderHandler), this.cookieEncoder, this.cookieDecoder);
            }
            catch (RuntimeException e) {
                this.sendDecodingFailures(e, msg);
                return;
            }
            ops.bind();
            this.listener.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
            ctx.fireChannelRead(msg);
            return;
        }
        if (this.persistentConnection && this.pendingResponses == 0) {
            if (msg instanceof LastHttpContent) {
                DecoderResult decoderResult3 = ((LastHttpContent)msg).decoderResult();
                if (decoderResult3.isFailure()) {
                    this.sendDecodingFailures(decoderResult3.cause(), msg);
                    return;
                }
                ctx.fireChannelRead(msg);
            } else {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Dropped HTTP content, since response has been sent already: {}"), msg);
                }
                ReferenceCountUtil.release(msg);
            }
            ctx.read();
            return;
        }
        if (this.overflow) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Buffering pipelined HTTP content, pending response count: {}, pending pipeline:{}"), this.pendingResponses, this.pipelined != null ? this.pipelined.size() : 0);
            }
            this.doPipeline(ctx, msg);
            return;
        }
        if (msg instanceof DecoderResultProvider && (decoderResult = ((DecoderResultProvider)msg).decoderResult()).isFailure()) {
            this.sendDecodingFailures(decoderResult.cause(), msg);
            return;
        }
        ctx.fireChannelRead(msg);
    }

    void sendDecodingFailures(Throwable t, Object msg) {
        this.persistentConnection = false;
        HttpServerOperations.sendDecodingFailures(this.ctx, t, msg);
    }

    void doPipeline(ChannelHandlerContext ctx, Object msg) {
        if (this.pipelined == null) {
            this.pipelined = Queues.unbounded().get();
        }
        if (!this.pipelined.offer(msg)) {
            ctx.fireExceptionCaught(Exceptions.failWithOverflow());
        }
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            boolean bl = this.nonInformationalResponse = !HttpTrafficHandler.isInformational(response);
            if (!HttpUtil.isKeepAlive(response) || !HttpTrafficHandler.isSelfDefinedMessageLength(response)) {
                this.pendingResponses = 0;
                this.persistentConnection = false;
            }
            if (!this.shouldKeepAlive()) {
                HttpUtil.setKeepAlive(response, false);
            }
            if (response.status().equals(HttpResponseStatus.CONTINUE)) {
                ctx.write(msg, promise);
                return;
            }
        }
        if (msg instanceof LastHttpContent) {
            if (!this.shouldKeepAlive()) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Detected non persistent http connection, preparing to close"), this.pendingResponses);
                }
                ctx.write(msg, promise.unvoid()).addListener(this).addListener(ChannelFutureListener.CLOSE);
                return;
            }
            ctx.write(msg, promise.unvoid()).addListener(this);
            if (!this.persistentConnection) {
                return;
            }
            if (this.nonInformationalResponse) {
                this.nonInformationalResponse = false;
                --this.pendingResponses;
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Decreasing pending responses, now {}"), this.pendingResponses);
                }
            }
            if (this.pipelined != null && !this.pipelined.isEmpty()) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Draining next pipelined request, pending response count: {}, queued: {}"), this.pendingResponses, this.pipelined.size());
                }
                ctx.executor().execute(this);
            } else {
                ctx.read();
            }
            return;
        }
        if (this.persistentConnection && this.pendingResponses == 0) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Dropped HTTP content, since response has been sent already: {}"), ReactorNetty.toPrettyHexDump(msg));
            }
            ReferenceCountUtil.release(msg);
            promise.setSuccess();
            return;
        }
        ctx.write(msg, promise);
    }

    @Override
    public void run() {
        Object next;
        HttpRequest nextRequest = null;
        while ((next = this.pipelined.peek()) != null) {
            if (next instanceof HttpRequest) {
                if (nextRequest != null) {
                    return;
                }
                if (!this.persistentConnection) {
                    this.discard();
                    return;
                }
                nextRequest = (HttpRequest)next;
                DecoderResult decoderResult = nextRequest.decoderResult();
                if (decoderResult.isFailure()) {
                    this.sendDecodingFailures(decoderResult.cause(), nextRequest);
                    this.discard();
                    return;
                }
                HttpServerOperations ops = new HttpServerOperations(Connection.from(this.ctx.channel()), this.listener, this.compress, nextRequest, ConnectionInfo.from(this.ctx.channel(), nextRequest, this.secure, this.remoteAddress, this.forwardedHeaderHandler), this.cookieEncoder, this.cookieDecoder);
                ops.bind();
                this.listener.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
            }
            this.ctx.fireChannelRead(this.pipelined.poll());
        }
        this.overflow = false;
    }

    @Override
    public void operationComplete(ChannelFuture future) {
        if (!future.isSuccess()) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(future.channel(), "Sending last HTTP packet was not successful, terminating the channel"), future.cause());
            }
        } else if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format(future.channel(), "Last HTTP packet was sent, terminating the channel"));
        }
        HttpServerOperations.cleanHandlerTerminate(future.channel());
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.discard();
    }

    final void discard() {
        if (this.pipelined != null && !this.pipelined.isEmpty()) {
            Object o;
            while ((o = this.pipelined.poll()) != null) {
                ReferenceCountUtil.release(o);
            }
        }
    }

    boolean shouldKeepAlive() {
        return this.pendingResponses != 0 && this.persistentConnection;
    }

    static boolean isSelfDefinedMessageLength(HttpResponse response) {
        return HttpUtil.isContentLengthSet(response) || HttpUtil.isTransferEncodingChunked(response) || HttpTrafficHandler.isMultipart(response) || HttpTrafficHandler.isInformational(response) || HttpTrafficHandler.isNotModified(response);
    }

    static boolean isInformational(HttpResponse response) {
        return response.status().codeClass() == HttpStatusClass.INFORMATIONAL;
    }

    static boolean isNotModified(HttpResponse response) {
        return HttpResponseStatus.NOT_MODIFIED.equals(response.status());
    }

    static boolean isMultipart(HttpResponse response) {
        String contentType = response.headers().get(HttpHeaderNames.CONTENT_TYPE);
        return contentType != null && contentType.regionMatches(true, 0, MULTIPART_PREFIX, 0, MULTIPART_PREFIX.length());
    }
}

