/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.websocket;

import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.NettyInbound;
import io.micrometer.shaded.reactor.util.annotation.Nullable;

public interface WebsocketInbound
extends NettyInbound {
    @Nullable
    public String selectedSubprotocol();

    public HttpHeaders headers();

    public Mono<WebSocketCloseStatus> receiveCloseStatus();

    default public WebsocketInbound aggregateFrames() {
        return this.aggregateFrames(65536);
    }

    default public WebsocketInbound aggregateFrames(int maxContentLength) {
        this.withConnection(c -> c.addHandlerLast(new WebSocketFrameAggregator(maxContentLength)));
        return this;
    }

    default public Flux<WebSocketFrame> receiveFrames() {
        return this.receiveObject().ofType(WebSocketFrame.class);
    }
}

