/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.tcp;

import io.micrometer.shaded.io.netty.bootstrap.ServerBootstrap;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.NettyInbound;
import io.micrometer.shaded.reactor.netty.NettyOutbound;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.BootstrapHandlers;
import io.micrometer.shaded.reactor.netty.tcp.TcpServer;
import io.micrometer.shaded.reactor.netty.tcp.TcpServerOperator;
import java.util.Objects;
import java.util.function.BiFunction;

final class TcpServerHandle
extends TcpServerOperator
implements ConnectionObserver {
    final BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler;

    TcpServerHandle(TcpServer server, BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler) {
        super(server);
        this.handler = Objects.requireNonNull(handler, "handler");
    }

    @Override
    public ServerBootstrap configure() {
        ServerBootstrap b = this.source.configure();
        ConnectionObserver observer = BootstrapHandlers.childConnectionObserver(b);
        BootstrapHandlers.childConnectionObserver(b, observer.then(this));
        return b;
    }

    @Override
    public void onStateChange(Connection connection, ConnectionObserver.State newState) {
        if (newState == ConnectionObserver.State.CONFIGURED) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(connection.channel(), "Handler is being applied: {}"), this.handler);
                }
                Mono.fromDirect(this.handler.apply(connection.inbound(), connection.outbound())).subscribe(connection.disposeSubscriber());
            }
            catch (Throwable t) {
                log.error(ReactorNetty.format(connection.channel(), ""), t);
                connection.channel().close();
            }
        }
    }
}

