/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd.internal;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.lang.Nullable;
import io.micrometer.statsd.internal.FlavorStatsdLineBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class TelegrafStatsdLineBuilder
extends FlavorStatsdLineBuilder {
    private final Object conventionTagsLock = new Object();
    private volatile NamingConvention namingConvention;
    private volatile String name;
    @Nullable
    private volatile String conventionTags;
    private volatile String tagsNoStat;
    private final ConcurrentMap<Statistic, String> tags = new ConcurrentHashMap<Statistic, String>();

    public TelegrafStatsdLineBuilder(Meter.Id id, MeterRegistry.Config config) {
        super(id, config);
    }

    @Override
    String line(String amount, @Nullable Statistic stat, String type) {
        this.updateIfNamingConventionChanged();
        return this.name + this.tagsByStatistic(stat) + ":" + amount + "|" + type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIfNamingConventionChanged() {
        NamingConvention next = this.config.namingConvention();
        if (this.namingConvention != next) {
            Object object = this.conventionTagsLock;
            synchronized (object) {
                if (this.namingConvention == next) {
                    return;
                }
                this.tags.clear();
                this.conventionTags = this.id.getTagsAsIterable().iterator().hasNext() ? this.id.getConventionTags(next).stream().map(t -> this.telegrafEscape(t.getKey()) + "=" + this.telegrafEscape(t.getValue())).collect(Collectors.joining(",")) : null;
            }
            this.name = this.telegrafEscape(next.name(this.id.getName(), this.id.getType(), this.id.getBaseUnit()));
            this.tagsNoStat = this.tags(null, this.conventionTags, "=", ",");
            this.namingConvention = next;
        }
    }

    private String tagsByStatistic(@Nullable Statistic stat) {
        return stat == null ? this.tagsNoStat : this.tags.computeIfAbsent(stat, this::telegrafTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String telegrafTag(@Nullable Statistic stat) {
        Object object = this.conventionTagsLock;
        synchronized (object) {
            return this.tags(stat, this.conventionTags, "=", ",");
        }
    }

    private String telegrafEscape(String value) {
        return value.replaceAll("=", "\\=").replaceAll("[\\s,:]", "_");
    }
}

