/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.core.publisher.SourceProducer;
import java.util.Objects;

final class FluxError<T>
extends Flux<T>
implements Fuseable.ScalarCallable,
SourceProducer<T> {
    final Throwable error;

    FluxError(Throwable error) {
        this.error = Objects.requireNonNull(error);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Operators.error(actual, this.error);
    }

    @Override
    public Object call() throws Exception {
        if (this.error instanceof Exception) {
            throw (Exception)this.error;
        }
        throw Exceptions.propagate(this.error);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        return null;
    }
}

