/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.core.publisher.SourceProducer;
import io.micrometer.shaded.reactor.util.context.Context;
import java.util.Objects;
import java.util.function.Function;

final class MonoDeferWithContext<T>
extends Mono<T>
implements SourceProducer<T> {
    final Function<Context, ? extends Mono<? extends T>> supplier;

    MonoDeferWithContext(Function<Context, ? extends Mono<? extends T>> supplier) {
        this.supplier = Objects.requireNonNull(supplier, "supplier");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Mono<T> p;
        Context ctx = actual.currentContext();
        try {
            p = Objects.requireNonNull(this.supplier.apply(ctx), "The Mono returned by the supplier is null");
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, ctx));
            return;
        }
        p.subscribe(actual);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        return null;
    }
}

