/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.ByteBufAllocator;
import io.micrometer.shaded.io.netty.buffer.Unpooled;
import io.micrometer.shaded.io.netty.channel.DefaultFileRegion;
import io.micrometer.shaded.io.netty.handler.stream.ChunkedNioFile;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.org.reactorstreams.Subscriber;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface NettyOutbound
extends Publisher<Void> {
    public ByteBufAllocator alloc();

    default public Mono<Void> neverComplete() {
        return this.then(Mono.never()).then();
    }

    default public NettyOutbound send(Publisher<? extends ByteBuf> dataStream) {
        return this.send(dataStream, ReactorNetty.PREDICATE_BB_FLUSH);
    }

    public NettyOutbound send(Publisher<? extends ByteBuf> var1, Predicate<ByteBuf> var2);

    default public NettyOutbound sendByteArray(Publisher<? extends byte[]> dataStream) {
        return this.send(ReactorNetty.publisherOrScalarMap(dataStream, Unpooled::wrappedBuffer));
    }

    default public NettyOutbound sendFile(Path file) {
        try {
            return this.sendFile(file, 0L, Files.size(file));
        }
        catch (IOException e) {
            return this.then(Mono.error(e));
        }
    }

    default public NettyOutbound sendFile(Path file, long position, long count) {
        Objects.requireNonNull(file, "filepath");
        return this.sendUsing(() -> FileChannel.open(file, StandardOpenOption.READ), (c, fc) -> {
            if (ReactorNetty.mustChunkFileTransfer(c, file)) {
                ReactorNetty.addChunkedWriter(c);
                try {
                    return new ChunkedNioFile((FileChannel)fc, position, count, 1024);
                }
                catch (Exception ioe) {
                    throw Exceptions.propagate(ioe);
                }
            }
            return new DefaultFileRegion((FileChannel)fc, position, count);
        }, ReactorNetty.fileCloser);
    }

    default public NettyOutbound sendFileChunked(Path file, long position, long count) {
        Objects.requireNonNull(file, "filepath");
        return this.sendUsing(() -> FileChannel.open(file, StandardOpenOption.READ), (c, fc) -> {
            ReactorNetty.addChunkedWriter(c);
            try {
                return new ChunkedNioFile((FileChannel)fc, position, count, 1024);
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }, ReactorNetty.fileCloser);
    }

    default public NettyOutbound sendGroups(Publisher<? extends Publisher<? extends ByteBuf>> dataStreams) {
        return this.send(Flux.from(dataStreams).concatMap(p -> Flux.from(p).concatWith(Mono.just(ReactorNetty.BOUNDARY)), 32), ReactorNetty.PREDICATE_GROUP_FLUSH);
    }

    default public NettyOutbound sendObject(Publisher<?> dataStream) {
        return this.sendObject(dataStream, ReactorNetty.PREDICATE_FLUSH);
    }

    public NettyOutbound sendObject(Publisher<?> var1, Predicate<Object> var2);

    public NettyOutbound sendObject(Object var1);

    default public NettyOutbound sendString(Publisher<? extends String> dataStream) {
        return this.sendString(dataStream, Charset.defaultCharset());
    }

    default public NettyOutbound sendString(Publisher<? extends String> dataStream, Charset charset) {
        return this.send(ReactorNetty.publisherOrScalarMap(dataStream, s -> {
            ByteBuf buffer = this.alloc().buffer();
            buffer.writeCharSequence((CharSequence)s, charset);
            return buffer;
        }));
    }

    public <S> NettyOutbound sendUsing(Callable<? extends S> var1, BiFunction<? super Connection, ? super S, ?> var2, Consumer<? super S> var3);

    @Override
    default public void subscribe(Subscriber<? super Void> s) {
        this.then().subscribe(s);
    }

    default public Mono<Void> then() {
        return Mono.empty();
    }

    default public NettyOutbound then(Publisher<Void> other) {
        return new ReactorNetty.OutboundThen(this, other);
    }

    default public NettyOutbound then(Publisher<Void> other, Runnable onCleanup) {
        return new ReactorNetty.OutboundThen(this, other, onCleanup);
    }

    public NettyOutbound withConnection(Consumer<? super Connection> var1);
}

