/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.tcp;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelPipeline;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.micrometer.shaded.io.netty.handler.logging.LoggingHandler;
import io.micrometer.shaded.io.netty.handler.proxy.HttpProxyHandler;
import io.micrometer.shaded.io.netty.handler.proxy.ProxyHandler;
import io.micrometer.shaded.io.netty.handler.proxy.Socks4ProxyHandler;
import io.micrometer.shaded.io.netty.handler.proxy.Socks5ProxyHandler;
import io.micrometer.shaded.io.netty.util.internal.StringUtil;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.channel.BootstrapHandlers;
import io.micrometer.shaded.reactor.netty.tcp.InetSocketAddressUtil;
import io.micrometer.shaded.reactor.netty.tcp.TcpUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class ProxyProvider {
    final String username;
    final Function<? super String, ? extends String> password;
    final Supplier<? extends InetSocketAddress> address;
    final Predicate<SocketAddress> nonProxyHostPredicate;
    final Supplier<? extends HttpHeaders> httpHeaders;
    final Proxy type;
    final long connectTimeoutMillis;
    static final LoggingHandler LOGGING_HANDLER = new LoggingHandler("io.micrometer.shaded.reactor.netty.proxy");

    public static TypeSpec builder() {
        return new Build();
    }

    @Nullable
    public static ProxyProvider findProxySupport(Bootstrap b) {
        DeferredProxySupport proxy = BootstrapHandlers.findConfiguration(DeferredProxySupport.class, b.config().handler());
        if (proxy == null) {
            return null;
        }
        return proxy.proxyProvider;
    }

    ProxyProvider(Build builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.nonProxyHostPredicate = builder.nonProxyHostPredicate;
        this.address = Objects.isNull(builder.address) ? () -> InetSocketAddressUtil.createResolved(builder.host, builder.port) : builder.address;
        this.httpHeaders = builder.httpHeaders;
        this.type = builder.type;
        this.connectTimeoutMillis = builder.connectTimeoutMillis;
    }

    public final Proxy getType() {
        return this.type;
    }

    public final Supplier<? extends InetSocketAddress> getAddress() {
        return this.address;
    }

    @Nullable
    @Deprecated
    public final Pattern getNonProxyHosts() {
        if (this.nonProxyHostPredicate instanceof RegexShouldProxyPredicate) {
            return ((RegexShouldProxyPredicate)this.nonProxyHostPredicate).pattern;
        }
        return null;
    }

    public final Predicate<SocketAddress> getNonProxyHostsPredicate() {
        return this.nonProxyHostPredicate;
    }

    public final ProxyHandler newProxyHandler() {
        ProxyHandler proxyHandler;
        InetSocketAddress proxyAddr = this.address.get();
        boolean b = Objects.nonNull(this.username) && Objects.nonNull(this.password);
        String username = this.username;
        String password = b ? this.password.apply(username) : null;
        switch (this.type) {
            case HTTP: {
                proxyHandler = b ? new HttpProxyHandler(proxyAddr, username, password, this.httpHeaders.get()) : new HttpProxyHandler(proxyAddr, this.httpHeaders.get());
                break;
            }
            case SOCKS4: {
                proxyHandler = Objects.nonNull(username) ? new Socks4ProxyHandler(proxyAddr, username) : new Socks4ProxyHandler(proxyAddr);
                break;
            }
            case SOCKS5: {
                proxyHandler = b ? new Socks5ProxyHandler(proxyAddr, username, password) : new Socks5ProxyHandler(proxyAddr);
                break;
            }
            default: {
                throw new IllegalArgumentException("Proxy type unsupported : " + (Object)((Object)this.type));
            }
        }
        proxyHandler.setConnectTimeoutMillis(this.connectTimeoutMillis);
        return proxyHandler;
    }

    public boolean shouldProxy(SocketAddress address) {
        SocketAddress addr = address;
        if (address instanceof TcpUtils.SocketAddressSupplier) {
            addr = ((TcpUtils.SocketAddressSupplier)address).get();
        }
        return addr instanceof InetSocketAddress && !this.nonProxyHostPredicate.test(addr);
    }

    @Deprecated
    public boolean shouldProxy(@Nullable String hostName) {
        return this.nonProxyHostPredicate == Build.ALWAYS_PROXY || hostName == null || this.nonProxyHostPredicate instanceof RegexShouldProxyPredicate && !((RegexShouldProxyPredicate)this.nonProxyHostPredicate).pattern.matcher(hostName).matches();
    }

    @Deprecated
    public String asSimpleString() {
        return "proxy=" + (Object)((Object)this.type) + "(" + this.address.get() + ")";
    }

    @Deprecated
    public String asDetailedString() {
        return "address=" + this.address.get() + ", nonProxyHosts=" + this.nonProxyHostPredicate + ", type=" + (Object)((Object)this.type);
    }

    public String toString() {
        return "ProxyProvider {address=" + this.address.get() + ", nonProxyHosts=" + this.nonProxyHostPredicate + ", type=" + (Object)((Object)this.type) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyProvider that = (ProxyProvider)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.getPasswordValue(), that.getPasswordValue()) && Objects.equals(this.getAddress().get(), that.getAddress().get()) && Objects.equals(this.getNonProxyHostsValue(), that.getNonProxyHostsValue()) && Objects.equals(this.httpHeaders.get(), that.httpHeaders.get()) && this.getType() == that.getType() && this.connectTimeoutMillis == that.connectTimeoutMillis;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.username, this.getPasswordValue(), this.getAddress().get(), this.getNonProxyHostsValue(), this.httpHeaders.get(), this.getType(), this.connectTimeoutMillis});
    }

    private boolean getNonProxyHostsValue() {
        return this.nonProxyHostPredicate.test(this.getAddress().get());
    }

    @Nullable
    private String getPasswordValue() {
        if (this.username == null || this.password == null) {
            return null;
        }
        return this.password.apply(this.username);
    }

    static final class ProxySupportConsumer
    implements BiConsumer<ConnectionObserver, Channel> {
        final Bootstrap bootstrap;
        final ProxyProvider proxyProvider;

        ProxySupportConsumer(Bootstrap bootstrap, ProxyProvider proxyProvider) {
            this.bootstrap = bootstrap;
            this.proxyProvider = proxyProvider;
        }

        @Override
        public void accept(ConnectionObserver connectionObserver, Channel channel) {
            if (this.proxyProvider.shouldProxy(this.bootstrap.config().remoteAddress())) {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addFirst("io.micrometer.shaded.reactor.left.proxyHandler", (ChannelHandler)this.proxyProvider.newProxyHandler());
                if (channel.pipeline().get("io.micrometer.shaded.reactor.left.loggingHandler") != null) {
                    pipeline.addBefore("io.micrometer.shaded.reactor.left.proxyHandler", "io.micrometer.shaded.reactor.left.proxyLoggingHandler", LOGGING_HANDLER);
                }
            }
        }
    }

    static final class DeferredProxySupport
    implements Function<Bootstrap, BiConsumer<ConnectionObserver, Channel>> {
        final ProxyProvider proxyProvider;

        DeferredProxySupport(ProxyProvider proxyProvider) {
            this.proxyProvider = proxyProvider;
        }

        @Override
        public BiConsumer<ConnectionObserver, Channel> apply(Bootstrap bootstrap) {
            return new ProxySupportConsumer(bootstrap, this.proxyProvider);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeferredProxySupport that = (DeferredProxySupport)o;
            return Objects.equals(this.proxyProvider, that.proxyProvider);
        }

        public int hashCode() {
            return Objects.hash(this.proxyProvider);
        }
    }

    public static interface Builder {
        public Builder username(String var1);

        public Builder password(Function<? super String, ? extends String> var1);

        public Builder port(int var1);

        public Builder nonProxyHosts(String var1);

        public Builder nonProxyHostsPredicate(Predicate<SocketAddress> var1);

        public Builder httpHeaders(Consumer<HttpHeaders> var1);

        public Builder connectTimeoutMillis(long var1);

        public ProxyProvider build();
    }

    public static interface AddressSpec {
        public Builder host(String var1);

        public Builder address(InetSocketAddress var1);

        public Builder address(Supplier<? extends InetSocketAddress> var1);
    }

    public static interface TypeSpec {
        public AddressSpec type(Proxy var1);
    }

    static final class RegexShouldProxyPredicate
    implements Predicate<SocketAddress> {
        public static final RegexShouldProxyPredicate DEFAULT_NON_PROXY = RegexShouldProxyPredicate.fromWildcardedPattern("localhost|127.*|[::1]|0.0.0.0|[::0]");
        private final String regex;
        private final Pattern pattern;

        public static RegexShouldProxyPredicate fromWildcardedPattern(String pattern) {
            String transformed;
            if (StringUtil.isNullOrEmpty(pattern)) {
                transformed = "$^";
            } else {
                CharSequence[] parts = pattern.split("\\|");
                for (int i = 0; i < parts.length; ++i) {
                    parts[i] = RegexShouldProxyPredicate.transformWildcardComponent((String)parts[i]);
                }
                transformed = String.join((CharSequence)"|", parts);
            }
            return new RegexShouldProxyPredicate(transformed);
        }

        private static String transformWildcardComponent(String in) {
            CharSequence[] parts = new String[]{"", "", ""};
            if (in.startsWith("*")) {
                parts[0] = ".*";
                in = in.substring(1);
            }
            if (in.endsWith("*")) {
                parts[2] = ".*";
                in = in.substring(0, in.length() - 1);
            }
            parts[1] = Pattern.quote(in);
            return String.join((CharSequence)"", parts);
        }

        private RegexShouldProxyPredicate(String pattern) {
            this.regex = pattern;
            this.pattern = Pattern.compile(this.regex, 2);
        }

        @Override
        public boolean test(SocketAddress socketAddress) {
            if (!(socketAddress instanceof InetSocketAddress)) {
                return false;
            }
            InetSocketAddress isa = (InetSocketAddress)socketAddress;
            String hostString = isa.getHostString();
            return hostString != null && this.pattern.matcher(hostString).matches();
        }

        public String toString() {
            return this.regex;
        }
    }

    static final class Build
    implements TypeSpec,
    AddressSpec,
    Builder {
        static final Supplier<? extends HttpHeaders> NO_HTTP_HEADERS = () -> null;
        static final Predicate<SocketAddress> ALWAYS_PROXY = a -> false;
        String username;
        Function<? super String, ? extends String> password;
        String host;
        int port;
        Supplier<? extends InetSocketAddress> address;
        Predicate<SocketAddress> nonProxyHostPredicate = ALWAYS_PROXY;
        Supplier<? extends HttpHeaders> httpHeaders = NO_HTTP_HEADERS;
        Proxy type;
        long connectTimeoutMillis = 10000L;

        Build() {
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public final Builder password(Function<? super String, ? extends String> password) {
            this.password = password;
            return this;
        }

        @Override
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            return this;
        }

        @Override
        public final Builder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public final Builder address(InetSocketAddress address) {
            Objects.requireNonNull(address, "address");
            this.address = () -> InetSocketAddressUtil.replaceWithResolved(address);
            return this;
        }

        @Override
        public final Builder address(Supplier<? extends InetSocketAddress> addressSupplier) {
            this.address = Objects.requireNonNull(addressSupplier, "addressSupplier");
            return this;
        }

        @Override
        public final Builder nonProxyHosts(String nonProxyHostsPattern) {
            return StringUtil.isNullOrEmpty(nonProxyHostsPattern) ? this.nonProxyHostsPredicate(ALWAYS_PROXY) : this.nonProxyHostsPredicate(new RegexShouldProxyPredicate(nonProxyHostsPattern));
        }

        @Override
        public final Builder nonProxyHostsPredicate(Predicate<SocketAddress> nonProxyHostsPredicate) {
            this.nonProxyHostPredicate = Objects.requireNonNull(nonProxyHostsPredicate, "nonProxyHostsPredicate");
            return this;
        }

        @Override
        public Builder httpHeaders(final Consumer<HttpHeaders> headers) {
            if (headers != null) {
                this.httpHeaders = () -> new DefaultHttpHeaders(){
                    {
                        headers.accept(this);
                    }
                };
            }
            return this;
        }

        @Override
        public final AddressSpec type(Proxy type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @Override
        public Builder connectTimeoutMillis(long connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        @Override
        public ProxyProvider build() {
            return new ProxyProvider(this);
        }
    }

    public static enum Proxy {
        HTTP,
        SOCKS4,
        SOCKS5;

    }
}

